<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include"../seguranca_aux_unid.php";
    protegePagina();
    include "../var_sub.php";
    $cont;
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Locais - SGT</title>
    <script type=”text/javascript”>
        $(function() {
            $(‘ul li a’).bind(‘click’,function(event){
                var $anchor = $(this);
                $(‘html, body’).stop().animate({
                    scrollLeft: $($anchor.attr(‘href’)).offset().left
                }, 1000);
                event.preventDefault();
            });
        })
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" name="id" id="id" action="cad_local_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Local:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="local" maxlength="80" size="30" required >
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Descrição:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="desc" maxlength="80" size="30" required>
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Local
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Descrição
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Apagar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar_query = ("SELECT * FROM tb_local ORDER BY local");
                        $buscar = $pdo_sgt->query($buscar_query);
                        $cont = $buscar->rowCount();
                        if($cont > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                echo'<tr align="center" id="id'.$ver['id'].'">'
                                    . '<td class="align-middle" scope="row" title="Local">'
                                        . '<div class="inp_div mx-sm-1">'
                                            . '<form name="id" id="id" action="alt_local_.php" method="POST">'
                                                . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                . '<input type="text" class="form-control-plaintext" name="local" value="'.$ver['local'].'" maxlength="80" size="30" required>'
                                                . '<input style="display: none" type="submit" name="ok" value="" />'
                                            . '</form>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Descrição">'
                                        . '<div class="inp_div mx-sm-1">'
                                            . '<form name="id" id="id" action="alt_local_desc_.php" method="POST">'
                                                . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                . '<input type="text" class="form-control-plaintext" name="desc" value="'.$ver['descricao'].'" maxlength="80" size="30" required>'
                                                . '<input style="display: none" type="submit" name="ok" value="" />'
                                            . '</form>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Apagar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="del_local.php?id='.$ver['id'].'">'
                                                . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot>Contagem de locais '.$cont.'</tfoot>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>