<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_comp_.php";
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function proximoCampo(atual,proximo){
            if(atual.value.length >= atual.maxLength){
                document.getElementById(proximo).focus();
            }
        }
        function limite_textarea(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont').innerHTML = resto;
            } else {
                document.getElementById('desc_tex_area').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
<title>Alteração de Computador - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form enctype="multipart/form-data" action="alt_comp_.php" method="POST">
                        <?php
                            $id = $dados['id'];
                        ?>  
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód.:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['cod_c']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">
                                    <?php
                                        $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>1 ORDER BY id");
                                        $busca_uni->execute();
                                        while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Setor:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="setor">
                                    <option value = \"a\">Sem Seleção</option>
                                    <?php
                                        $busca_set = $pdo_sgt->query("SELECT * FROM tb_setores ORDER BY setor");
                                        while (@$linha = $busca_set->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($dados['setor'] == $valor){echo ' selected';} echo ">$valor - $linha[setor]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo">
                                    <?php
                                        $busca_tipo = $pdo_sgt->query("SELECT * FROM tb_tipos WHERE comp='1' ORDER BY tipo");
                                        while (@$linha = $busca_tipo->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($dados['tipo'] == $valor){echo ' selected';} echo ">$valor - $linha[tipo]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="modelo">
                                    <?php
                                        $busca_marc = $pdo_sgt->query("SELECT * FROM tb_marcas ORDER BY marca");
                                        while (@$linha_marc = $busca_marc->fetch(PDO::FETCH_ASSOC)){
                                            $valor_marc = $linha_marc[@id];
                                            $busca_mod = $pdo_sgt->query("SELECT * FROM tb_modelos WHERE marca='".$valor_marc."' AND tipo='1' ORDER BY modelo");
                                            while (@$linha_mod = $busca_mod->fetch(PDO::FETCH_ASSOC)){
                                                $valor_mod = $linha_mod['id']; 
                                                echo "<option value = \"$valor_mod\""; if($dados['modelo'] == $valor_mod){echo ' selected';} echo ">$valor_mod - $linha_marc[marca] - $linha_mod[modelo] </option>";
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Série:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nserie" maxlength="80" required value="<?php echo $dados['nserie']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Data de Aquisição:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="daquise" maxlength="10" required value="<?php echo date('d/m/Y', strtotime($dados['daquise'])); ?>" onkeyup="proximoCampo(this, 'garantia')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Termino da Garantia:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="garantia" id="garantia" required maxlength="10" value="<?php echo date('d/m/Y', strtotime($dados['garantia'])); ?>" onkeyup="proximoCampo(this, 'pmae')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Placa Mãe:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="pmae" id="pmae" maxlength="80" required value="<?php echo $dados['pmae']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Processador:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="proc">
                                    <?php
                                        $busca_proc = $pdo_sgt->query("SELECT * FROM tb_proc ORDER BY id");
                                        while (@$linha_proc = $busca_proc->fetch(PDO::FETCH_ASSOC)){
                                            $valor_proc = $linha_proc[@id]; 
                                            echo "<option value = \"$valor_proc\""; if($dados['proc'] == $valor_proc){echo ' selected';} echo ">$valor_proc - $linha_proc[proc] - $linha_proc[des_proc]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Processadores:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nproc" maxlength="4" required value="<?php echo $dados['nproc']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Memória RAM:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="ram" maxlength="10" required value="<?php echo $dados['ram']; ?> GB">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Clok RAM:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="ram_clok">
                                    <?php
                                        $busca_clok = $pdo_sgt->query("SELECT * FROM tb_ram_clok ORDER BY clok");
                                        while (@$linha_clok = $busca_clok->fetch(PDO::FETCH_ASSOC)){
                                            $valor_clok = $linha_clok[@id]; 
                                            echo "<option value = \"$valor_clok\""; if($dados['ram_clok'] == $valor_clok){echo ' selected';} echo ">$valor_clok - $linha_clok[clok] MHz</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">HD:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="hd" maxlength="10" required value="<?php echo $dados['hd']; ?> GB">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo HD:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo_hd">
                                    <?php
                                        $busca_hd = $pdo_sgt->query("SELECT * FROM tb_tipo_hd ORDER BY tipo");
                                        while (@$linha_hd = $busca_hd->fetch(PDO::FETCH_ASSOC)){
                                            $valor_hd = $linha_hd[@id]; 
                                            echo "<option value = \"$valor_hd\""; if($dados['tipo_hd'] == $valor_hd){echo ' selected';} echo ">$valor_hd - $linha_hd[tipo]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Descrição HD:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="desc_hd" maxlength="255" value="<?php echo $dados['desc_hd']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Loja:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="loja" id="loja" maxlength="120" value="<?php echo $dados['loja']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número da Nota Fiscal:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nnota" maxlength="40" required value="<?php echo $dados['nnota']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Valor:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="valor" maxlength="40" value="<?php echo number_format($dados['valor'], 2, ',', '.'); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número do Imobilizado:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nptri" maxlength="40" required value="<?php echo $dados['nptri']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Descrição do Equipamento: </label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="exampleFormControlTextarea1" name="desc_tex_area" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea(this.value)"><?php echo $dados['desc_comp']; ?></textarea>
                                <label>Caracteres restantes: <span id="cont">500</span></label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Ativo</label>
                            <div class="col-sm-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="ativo" name="ativo" value="ativo"<?php if($dados['ativo'] != 0){echo ' CHECKED';}?>>
                                    <label class="custom-control-label" for="ativo"></label>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                        <button type="button" class="btn btn-dark" align="center" onclick="javascript: window.location.href='alt_comp_arq.php?id=<?php echo $del;?>';">Altera Arquivo</button>
                        <button type="button" class="btn btn-danger" align="center" onclick="javascript: window.location.href='del_comp.php?id=<?php echo $del;?>';">Apagar</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="container-fluid content_tb_sgt">
            <div class="table-responsive-sm tab_sgt content_tb_sgt">
                <div class="form-group row"></div>
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr class="table-primary">
                            <th scope="col">Data</th>
                            <th scope="col">Usuário</th>
                            <th scope="col">Tipo</th>
                            <th scope="col">Descrição</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $busca_hist=$pdo_sgt->prepare("SELECT * FROM tb_oc_comp where cod_c=:id");
                        $busca_hist->bindValue(":id",$id);
                        $busca_hist->execute();
                        if($busca_hist->rowCount() > 0){
                            while($ver = $busca_hist->fetch(PDO::FETCH_ASSOC)){
                                switch($ver['tipo']) {
                                    case 1 : $tipo="Alteração";
                                        break;
                                    case 2 : $tipo="Erro";
                                        break;
                                    case 3 : $tipo="Movimentação";
                                        break;
                                    default: $tipo="Cadastro";
                                }
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Data">'.date('d/m/Y H:i:s', strtotime($ver['dt'])).'</td>'
                                    . '<td class="align-middle" title="Usuário">'.$ver['user_nome'].'</td>'
                                    . '<td class="align-middle" title="Tipo">'.$tipo.'</td>'
                                    . '<td class="align-middle" title="Descrição">'.$ver['des'].'</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais';
                        }
                    ?>
                    </tbody>
                    <tfoot></tfoot>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>