<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
    include "rodape_.php";
    include "../var_sub.php";
    $busca=$pdo_sgt->prepare("SELECT * FROM tb_conf WHERE conf=:conf");
    $busca->bindValue(":conf","rodape");
    $busca->execute();
    $dados=$busca->fetch(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function limite_textarea_1(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont_1').innerHTML = resto;
            } else {
                document.getElementById('pe_1').value = valor.substr(0,quant);
            }
        }
        function limite_textarea_2(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont_2').innerHTML = resto;
            } else {
                document.getElementById('pe_2').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
<title>Rodapé - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form method="POST" action="rodape_.php">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Complemento - Login</label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="pe_1" name="pe_1" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea_1(this.value)"><?php echo $dados['var1']; ?></textarea>
                                <label>Caracteres restantes: <span id="cont_1">500</span></label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Complemento - Home</label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="pe_2" name="pe_2" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea_2(this.value)"><?php echo $dados['var2']; ?></textarea>
                                <label>Caracteres restantes: <span id="cont_2">500</span></label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>