<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_key_.php";
    include "../var_sub.php";
    require "../criptografia_sgt.php";
    include "../chave_sgt.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Alteração de Senhas - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form action="alt_key_.php" method="POST">
                        <?php
                            if($_SERVER['REQUEST_METHOD']){
                                $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                $busca_unid->bindValue(":id",$dados['unidade']);
                                $busca_unid->execute();
                                $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                            }
                        ?>
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">
                                    <option value = "1">Geral</option>
                                    <?php
                                        if($unid_temp == 1){
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>:id ORDER BY id");
                                            $busca_uni->bindValue(":id",2);
                                            $busca_uni->execute();
                                        } else {
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id ORDER BY id");
                                            $busca_uni->bindValue(":id",$unid_master);
                                            $busca_uni->execute();
                                        }
                                        while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nível:</label>
                            <div class="col-sm-3">
                                <?php
                                    if($nivel < 4){
                                        echo '<select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="nivel">';
                                            switch($nivel) {
                                                case 1 :
                                                    echo '<option value="1"'; if($dados['nivel'] == 1){echo 'selected';} echo '>Máster</option>';
                                                    echo '<option value="2"'; if($dados['nivel'] == 2){echo 'selected';} echo '>Administrador</option>';
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo 'selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo 'selected';} echo '>Auxiliar Unidade</option>';
                                                break;
                                                case 2 :
                                                    echo '<option value="2"'; if($dados['nivel'] == 2){echo 'selected';} echo '>Administrador</option>';
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo 'selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo 'selected';} echo '>Auxiliar Unidade</option>';
                                                break;
                                                default:
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo 'selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo 'selected';} echo '>Auxiliar Unidade</option>';
                                            }
                                        echo '</select>';
                                    } else {
                                        echo '<input type="text" class="form-control" name="nivel" disabled  value="Auxiliar Unidade">';
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Descrição:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="desc" required value="<?php echo $dados['descricao']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Usuário:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="user" required value="<?php echo $dados['usuario']; ?>">
                            </div>
                        </div>
                        <?php
                            $sgt_cript = new SGT_KEY();
                            $sgt_cript -> chave = $chave_num;
                            $sgt_cript -> add_text = md5(sha1($chave_txt));
                            $key_desc = $sgt_cript -> ver($dados['senha']);
                        ?>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Senha:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="key" required value="<?php echo $key_desc; ?>">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                        <button type="button" class="btn btn-danger" align="center" onclick="javascript: window.location.href='del_key.php?id=<?php echo $del;?>';">Apagar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>