<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_pp_.php";
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Alteração de Passo a Passo - SGT</title>
    <script src="../tinymce/tinymce.min.js"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea',
            height: 300,
            theme: 'modern',
            language: 'pt_BR',
            mobile: {
                theme: 'beta-mobile',
                plugins: [ 'autosave' ]
            },
            plugins: 'code print preview fullpage searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists textcolor wordcount imagetools contextmenu colorpicker',
            toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',
            image_advtab: true,
            browser_spellcheck: true,
            contextmenu: false
        });
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col align-self-center">
                    <form method="POST" action="alt_pp_.php">
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>">
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Unidade:</label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="unidade">
                                    <option value = "1">Geral</option>
                                    <?php
                                        if($unid_temp == 1){
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>:id ORDER BY id");
                                            $busca_uni->bindValue(":id",2);
                                            $busca_uni->execute();
                                        } else {
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id ORDER BY id");
                                            $busca_uni->bindValue(":id",$unid_master);
                                            $busca_uni->execute();
                                        }
                                        while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Nível:</label>
                                <?php
                                    if($nivel < 4){
                                        echo '<select class="custom-select custom-select-sm mr-sm-2" name="nivel">';
                                            switch($nivel) {
                                                case 1 :
                                                    echo '<option value="1"'; if($dados['nivel'] == 1){echo ' selected';} echo '>Master</option>';
                                                    echo '<option value="2"'; if($dados['nivel'] == 2){echo ' selected';} echo '>Administrador</option>';
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo ' selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo ' selected';} echo '>Auxiliar Unidade</option>';
                                                break;
                                                case 2 :
                                                    echo '<option value="2"'; if($dados['nivel'] == 2){echo ' selected';} echo '>Administrador</option>';
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo ' selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo ' selected';} echo '>Auxiliar Unidade</option>';
                                                break;
                                                default:
                                                    echo '<option value="3"'; if($dados['nivel'] == 3){echo ' selected';} echo '>Gerente Unidade</option>';
                                                    echo '<option value="4"'; if($dados['nivel'] == 4){echo ' selected';} echo '>Auxiliar Unidade</option>';
                                            }
                                        echo '</select><br />';
                                    } else {
                                        echo '<input style="display: none" type="text"  readonly name="nivel" id="nivel" value="4">';
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Título:</label>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <input class="form-control form-control-sm mx-sm-1" type="text" size="60" name="tt" required value="<?php echo $dados['tt']; ?>">
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Descrição:</label>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <input class="form-control form-control-sm mx-sm-1" type="text" size="80" name="desc" required value="<?php echo $dados['descricao']; ?>">
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Passo a Passo:</label>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <textarea name="pp"><?php echo $dados['pp']; ?></textarea>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <p class="text-left">Todos os campos devem ser preenchidos.</p>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                        <button type="button" class="btn btn-danger" align="center" onclick="javascript: window.location.href='del_pp.php?id=<?php echo $del;?>';">Apagar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>