<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm_av.php");
    protegePagina();
    include "../var_sub.php";
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Cadastro de Chaves de Licenças - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form method="POST" action="cad_cha_.php">
                        <h5>Todos os campos devem ser preenchidos.</h5>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <?php
                                    if($_SERVER['REQUEST_METHOD']){
                                        $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                        $busca_unid->bindValue(":id",$unid_temp);
                                        $busca_unid->execute();
                                        $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                                    }
                                    if($unid_temp == 1){
                                        echo '<select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">';
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY unidade");
                                            $busca_uni->execute();
                                            while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                                $valor = $linha['id']; 
                                                echo "<option value = \"$valor\">$linha[unidade]</option>";
                                            }
                                        echo '</select>';
                                    } else {
                                        echo '<input type="text" class="form-control" name="unidade" disabled value="'.$dados_unid['unidade'].'">';
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="nivel">
                                    <option value="1">Máster</option>
                                    <option value="2">Administrador</option>
                                    <option value="3">Gerente Unidade</option>
                                    <option value="4">Auxiliar Unidade</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Produto:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="pro" maxlength="80" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Chave de Licença:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="cha" maxlength="120" required>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>