<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    $fun = 0;
    $cont = 0;
    $t_nivel = $nivel - 1;
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Chaves de Licenças - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nível
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Produto
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Chave
                                </div>
                            </th>
                            <?php
                                if($nivel == 1){
                                    echo '<th scope="col">'
                                        . '<div class="mx-sm-1">'
                                            . 'Editar'
                                        . '</div>'
                                    . '</th>';
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        
                        if($unid_master == 1){
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_chaves WHERE nivel>:nivel ORDER BY unidade,nivel,produto,chave");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->execute();
                        } else {
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_chaves WHERE nivel>:nivel AND ( unidade=:unidade1 OR unidade=:unidade2 ) ORDER BY unidade,nivel,produto,chave");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->bindValue(":unidade1",$unid_master);
                            $buscar->bindValue(":unidade2",1);
                            $buscar->execute();
                        }
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                $buscar_unid->bindValue(":id",$ver['unidade']);
                                $buscar_unid->execute();
                                $dados_unid=$buscar_unid->fetch(PDO::FETCH_ASSOC);
                                $unid_tb=$dados_unid['unidade'];
                                switch($ver['nivel']) { case 1 : $nivel_tb="Master"; break; case 2 : $nivel_tb="Administrador"; break; case 3 : $nivel_tb="Gerente Unidade"; break; default: $nivel_tb="Auxiliar Unidade"; }
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$unid_tb
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Nível">'
                                        . '<div class="mx-sm-1">'
                                            .$nivel_tb
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Produto">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['produto']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Chave">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['chave']
                                        . '</div>'
                                    . '</td>';
                                    if($nivel == 1){
                                        echo '<td class="align-middle" title="Editar - '.$ver['produto'].'">'
                                            . '<div class="mx-sm-1">'
                                                . '<a href="alt_cha.php?id='.$ver['id'].'">'
                                                    . '<img title="Editar - '.$ver['produto'].'" src="../img/editar.png" height="15" width="15">'
                                                . '</a>'
                                            . '</div>'
                                        . '</td>';
                                    }
                                echo '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de Chaves '.$buscar->rowCount().'</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>