<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    $t_nivel = $nivel - 1;
    require "../criptografia_sgt.php";
    include "../chave_sgt.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="cad_key_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Unidade:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="unidade">
                        <option value = \"0\">Sem Seleção</option>
                            <?php
                                if($unid_temp == 1){
                                    $sqlu = "SELECT * FROM tb_unidades ORDER BY unidade";
                                } else {
                                    $sqlu = "SELECT * FROM tb_unidades WHERE id='".$unid_master."' ORDER BY unidade";
                                }
                                $busca_uni = $pdo_sgt->prepare($sqlu);
                                $busca_uni->execute();
                                while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                    $valor = $linha['id']; 
                                    echo "<option value = \"$valor\""; if($unid_master == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Nível:</label>
                            <?php
                                if($nivel < 4){
                                    echo '<select class="custom-select form-control-sm mx-sm-1" name="nivel">';
                                        switch($nivel) {
                                            case 1 :
                                                echo '<option value="1">Master</option>';
                                                echo '<option value="2">Administrador</option>';
                                                echo '<option value="3">Gerente Unidade</option>';
                                                echo '<option value="4">Auxiliar Unidade</option>';
                                            break;
                                            case 2 :
                                                echo '<option value="2">Administrador</option>';
                                                echo '<option value="3">Gerente Unidade</option>';
                                                echo '<option value="4">Auxiliar Unidade</option>';
                                            break;
                                            default:
                                                echo '<option value="3">Gerente Unidade</option>';
                                                echo '<option value="4">Auxiliar Unidade</option>';
                                        }
                                    echo '</select><br />';
                                } else {
                                    echo '<input style="display: none" type="text"  readonly name="nivel" id="nivel" value="4">';
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Descrição:</label>
                        <input class="form-control form-control-sm mx-sm-1" size="25" maxlength="80" type="text" name="desc">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Usuário:</label>
                        <input class="form-control form-control-sm mx-sm-1" size="20" maxlength="40" type="text" name="user" required>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Senha:</label>
                        <input class="form-control form-control-sm mx-sm-1" size="30" maxlength="120" type="text" name="key" required>
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <?php
                                if($nivel < 4){
                                    echo '<th scope="col">'
                                        . '<div class="mx-sm-1">'
                                            . 'Nível'
                                        . '</div>'
                                    . '</th>';
                                }
                            ?>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Descrição
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Usuário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Senha
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_key WHERE nivel>:nivel ORDER BY unidade,descricao,usuario");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->execute();
                        } else {
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_key WHERE nivel>:nivel AND ( unidade=:unidade1 OR unidade=:unidade2 ) ORDER BY unidade,descricao,usuario");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->bindValue(":unidade1",$unid_master);
                            $buscar->bindValue(":unidade2",1);
                            $buscar->execute();
                        }
                        $cont = $buscar->rowCount();
                        if($cont > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                if($ver['unidade'] != 0){
                                    if($_SERVER['REQUEST_METHOD']){
                                        $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                        $buscar_unid->bindValue(":id",$ver['unidade']);
                                        $buscar_unid->execute();
                                        $dados_unid=$buscar_unid->fetch(PDO::FETCH_ASSOC);
                                        $unid_tb=$dados_unid['unidade'];
                                    }
                                } else {
                                    $unid_tb = "Geral";
                                }
                                switch($ver['nivel']) { case 1 : $nivel_tb="Máster"; break; case 2 : $nivel_tb="Administrador"; break; case 3 : $nivel_tb="Gerente Unidade"; break; default: $nivel_tb="Auxiliar Unidade"; }
                                $sgt_cript = new SGT_KEY();
                                $sgt_cript -> chave = $chave_num;
                                $sgt_cript -> add_text = md5(sha1($chave_txt));
                                $key_desc = $sgt_cript -> ver($ver['senha']);
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$unid_tb
                                        . '</div>'
                                    . '</td>';
                                    if($nivel < 4){
                                        echo '<td class="align-middle" title="Nível">'
                                            . '<div class="mx-sm-1">'
                                                .$nivel_tb
                                            . '</div>'
                                        . '</td>';
                                    }
                                    echo '<td class="align-middle" title="Produto">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['descricao']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Usuário">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['usuario']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Chave">'
                                        . '<div class="mx-sm-1">'
                                            .$key_desc
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Editar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="alt_key.php?id='.$ver['id'].'">'
                                                . '<img title="Editar" src="../img/editar.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        ?>
                    </tbody>
                    <tfoot></tfoot>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>