<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_geral.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Equipamentos - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="table-responsive-sm tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Cód.
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Arquivo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Setor
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Marca
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Modelo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Número de Série
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Data de Aquisição
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Término da Garantia
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    N. do Imobilizado
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Status
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar_query = ("SELECT * FROM tb_equipamentos ORDER BY  ativo DESC,unidade ASC, cod_e DESC");
                        } else {
                            $buscar_query = ("SELECT * FROM tb_equipamentos WHERE unidade='".$unid_master."' ORDER BY  ativo DESC,unidade ASC, cod_e DESC"); 
                        }
                        $buscar = $pdo_sgt->query($buscar_query);
                        $cont = $buscar->rowCount();
                        if($cont > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $valor_marc = "";
                                $valor_mod = "";
                                $busca_unid=$pdo_sgt->query("SELECT * FROM tb_unidades WHERE id='".$ver['unidade']."'");
                                $dados_unid = $busca_unid->fetch(PDO::FETCH_ASSOC);
                                $qry_mod = $pdo_sgt->query("SELECT * FROM tb_modelos WHERE id='".$ver['modelo']."'");
                                while ($linha_mod = $qry_mod->fetch(PDO::FETCH_ASSOC)){
                                    $valor_mod = $linha_mod['modelo'];
                                    $sql_marc = "SELECT * FROM tb_marcas WHERE id='".$linha_mod['marca']."'";
                                    $qry_marc = $pdo_sgt->query($sql_marc);                    
                                    while ($linha_marc = $qry_marc->fetch(PDO::FETCH_ASSOC)){
                                        $valor_marc = $linha_marc['marca'];   
                                    }  
                                }
                                $busca_set=$pdo_sgt->query("SELECT * FROM tb_setores WHERE id='".$ver['setor']."'");
                                $dados_set = $busca_set->fetch(PDO::FETCH_ASSOC);
                                if($ver['f_url']== ""){
                                    $url= '';
                                } else {
                                    $url= '<a href="'.$sgturl.$ver['f_url'].'" target="_blank"><img title="Editar - '.$ver['cod_e'].'" src="../img/doc.png" height="15" width="15"></a>';
                                }
                                if($ver['ativo'] == 1){$status="Ativo";}else{$status="Desativado";}
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Código - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['cod_e']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Editar - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="alt_eqp.php?id='.$ver['id'].'">'
                                                . '<img title="Editar - '.$ver['cod_e'].'" src="../img/editar.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Arquivo da Nota Fiscal - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$url
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Unidade - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_unid['unidade']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Setor - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_set['setor']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Marca - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$valor_marc
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Modelo - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$valor_mod
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Número de Série - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['nserie']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Data de Aquisição - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .date('d/m/Y', strtotime($ver['daquise']))
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Término da Garantia - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .date('d/m/Y', strtotime($ver['garantia']))
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Número do Imobilizado - '.$ver['cod_e'].'">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['nptri']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Status">'
                                        . '<div class="mx-sm-1">'
                                            .$status
                                        . '</div>'
                                    .'</td>'
                                . '</tr>';
                            }
                        } else {
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot>Contagem de equipamentos '.$cont.'</table>'
                    . '</table>';
                ?>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>