<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var_sub.php";
    $fun = 0;
    $cont = 0;
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Help Desk - Por Usuários - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Usuário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Relatos-Aguardando
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Relatos-Em Andamento
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Relatos-Pausa
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Relatos-Encerrado
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Atendidos-Aguardando
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Atendidos-Em Andamento
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Atendidos-Pausa
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Atendidos-Encerrado
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE ativo=:ativo AND id>:id ORDER BY usuario");
                        $buscar->bindValue(":ativo",1);
                        $buscar->bindValue(":id",1);
                        $buscar->execute();
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $cont_hd_de_1=0;
                                $cont_hd_de_2=0;
                                $cont_hd_de_3=0;
                                $cont_hd_de_4=0;
                                $cont_hd_para_1=0;
                                $cont_hd_para_2=0;
                                $cont_hd_para_3=0;
                                $cont_hd_para_4=0;
                                $buscar_hd_de_1=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE de=:de AND status=:status");
                                $buscar_hd_de_1->bindValue(":de",$ver['id']);
                                $buscar_hd_de_1->bindValue(":status",1);
                                $buscar_hd_de_1->execute();
                                $cont_hd_de_1 = $buscar_hd_de_1->rowCount();
                                $buscar_hd_de_2=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE de=:de AND status=:status");
                                $buscar_hd_de_2->bindValue(":de",$ver['id']);
                                $buscar_hd_de_2->bindValue(":status",2);
                                $buscar_hd_de_2->execute();
                                $cont_hd_de_2 = $buscar_hd_de_2->rowCount();
                                $buscar_hd_de_3=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE de=:de AND status=:status");
                                $buscar_hd_de_3->bindValue(":de",$ver['id']);
                                $buscar_hd_de_3->bindValue(":status",3);
                                $buscar_hd_de_3->execute();
                                $cont_hd_de_3 = $buscar_hd_de_3->rowCount();
                                $buscar_hd_de_4=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE de=:de AND status=:status");
                                $buscar_hd_de_4->bindValue(":de",$ver['id']);
                                $buscar_hd_de_4->bindValue(":status",4);
                                $buscar_hd_de_4->execute();
                                $cont_hd_de_4 = $buscar_hd_de_4->rowCount();
                                $buscar_hd_para_1=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE para=:para AND status=:status");
                                $buscar_hd_para_1->bindValue(":para",$ver['id']);
                                $buscar_hd_para_1->bindValue(":status",1);
                                $buscar_hd_para_1->execute();
                                $cont_hd_para_1 = $buscar_hd_para_1->rowCount();
                                $buscar_hd_para_2=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE para=:para AND status=:status");
                                $buscar_hd_para_2->bindValue(":para",$ver['id']);
                                $buscar_hd_para_2->bindValue(":status",2);
                                $buscar_hd_para_2->execute();
                                $cont_hd_para_2 = $buscar_hd_para_2->rowCount();
                                $buscar_hd_para_3=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE para=:para AND status=:status");
                                $buscar_hd_para_3->bindValue(":para",$ver['id']);
                                $buscar_hd_para_3->bindValue(":status",3);
                                $buscar_hd_para_3->execute();
                                $cont_hd_para_3 = $buscar_hd_para_3->rowCount();
                                $buscar_hd_para_4=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE para=:para AND status=:status");
                                $buscar_hd_para_4->bindValue(":para",$ver['id']);
                                $buscar_hd_para_4->bindValue(":status",4);
                                $buscar_hd_para_4->execute();
                                $cont_hd_para_4 = $buscar_hd_para_4->rowCount();
                                $busca=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:unidade");
                                $busca->bindValue(":unidade",$ver['unidade']);
                                $busca->execute();
                                $dados = $busca->fetch(PDO::FETCH_ASSOC);
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Caso">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['usuario']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Relator">'
                                        . '<div class="mx-sm-1">'
                                            .$dados['unidade']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Data de Abertura">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_de_1
                                        . '</div>'
                                    . '<td class="align-middle" title="Atribuído">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_de_2
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Produto">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_de_3
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Prioridade">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_de_4
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Resumo">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_para_1
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Status">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_para_2
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Visibilidade">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_para_3
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Visibilidade">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_para_4
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de usuários '.$buscar->rowCount().'.</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>