<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Help Desk - Lista Produtos - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="cad_pro_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Produto:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="pro" maxlength="80" size="30" required >
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Produto
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Chamados
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Apagar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar=$pdo_sgt->query("SELECT * FROM tb_hd_pro ORDER BY produto");
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $buscar_hd_pro=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE produto=:produto");
                                $buscar_hd_pro->bindValue(":produto",$ver['id']);
                                $buscar_hd_pro->execute();
                                $cont_hd_pro = $buscar_hd_pro->rowCount();
                                echo'<tr align="center" id="id'.$ver['id'].'">'
                                    . '<td class="align-middle" scope="row" title="Setor">'
                                        . '<div class="inp_div mx-sm-1">'
                                            . '<form action="alt_pro_.php" method="POST">'
                                                . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                . '<input type="text" class="form-control-plaintext" size="30" name="pro" id="pro" value="'.$ver['produto'].'">'
                                                . '<input style="display: none" type="submit" name="ok" value="" />'
                                            . '</form>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Número de Casos">'
                                        . '<div class="mx-sm-1">'
                                            .$cont_hd_pro
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Apagar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="del_pro.php?id='.$ver['id'].'">'
                                                . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot>Contagem de Produto '.$buscar->rowCount().'</tfoot>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>