<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm_av.php");
    protegePagina();
    include "../var_sub.php";
    include 'calc_ipv4_.php';
    $ip_temp = '0.0.0.0';
    $ip_inicio = '0';
    $ip_fim = '0';
    $ipi = explode( '.', $ip_temp );
    $ipf = explode( '.', $ip_temp );
    if($_SERVER['REQUEST_METHOD']=='GET'){
        $id_get = $_GET['id'];
        $busca_ip=$pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE id=:id");
        $busca_ip->bindValue(":id",$id_get);
        $busca_ip->execute();
        $dados_ip=$busca_ip->fetch(PDO::FETCH_ASSOC);
        $del = $dados_ip['id'];
        $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
        $busca_unid->bindValue(":id",$dados_ip['unidade']);
        $busca_unid->execute();
        $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
        $ip_c=$dados_ip['ip']. "/" .$dados_ip['cidr'];
    }
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Apagar de IPs da Unidade - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
           <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <h4>ATENÇÃO, OS DADOS SERÃO APAGADOS!!!</h4>
                    <?php
                        $ip = new calc_ipv4( $ip_c );
                        if( $ip->valida_endereco() ) {
                            echo '<p>Configurações de rede para <span>' . $ip_c . '</span> </p>';
                            echo "<pre>";
                            echo "<b>Endereço/Rede: </b>" . $ip->endereco_completo() . '<br>';
                            echo "<b>Endereço: </b>" . $ip->endereco() . '<br>';
                            echo "<b>Prefixo CIDR: </b>/" . $ip->cidr() . '<br>';
                            echo "<b>Máscara de sub-rede: </b>" . $ip->mascara() . '<br>';
                            echo "<b>IP da Rede: </b>" . $ip->rede() . '/' . $ip->cidr() . '<br>';
                            echo "<b>Broadcast da Rede: </b>" . $ip->broadcast() . '<br>';
                            echo "<b>Primeiro Host: </b>" . $ip->primeiro_ip() . '<br>';
                            echo "<b>Último Host: </b>" . $ip->ultimo_ip() . '<br>';
                            echo "<b>Total de IPs:  </b>" . $ip->total_ips() . '<br>';
                            echo "<b>Hosts: </b>" . $ip->ips_rede();
                            echo "</pre>";
                            $ipi = explode( '.', $ip->primeiro_ip() );
                            $ipf = explode( '.', $ip->ultimo_ip() );
                            $ip_inicio = '1';
                            $ip_fim = '254';
                            $ip_rede = $ip->endereco_completo();
                        } else {
                            echo 'Endereço IPv4 inválido!';
                        }
                    ?>
                </div>
            </div>
        </div>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form method="POST" action="del_ip_unid_.php" onsubmit="return true">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" readonly value="<?php echo $dados_unid['unidade']; ?>">
                                <input style="display: none" type="text" readonly name="unidade" id="unidade" value="<?php echo $dados_ip['unidade']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">IP Início:</label>
                            <div class="col-sm-3">
                                <label class="col-form-label"><?php echo $ipi[0]; ?>.<?php echo $ipi[1]; ?>.<?php echo $ipi[2]; ?>.<?php echo $ipi[3]; ?></label>
                                <input style="display: none" type="text" readonly name="ipi_1" id="ipi_1" value="<?php echo $ipi[0]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipi_2" id="ipi_2" value="<?php echo $ipi[1]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipi_3" id="ipi_3" value="<?php echo $ipi[2]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipi_4" id="ipi_4" value="<?php echo $ipi[3]; ?>"/>
                                <input style="display: none" type="text" readonly name="ip_rede" id="ip_rede" value="<?php echo $ip_rede; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">IP Final:</label>
                            <div class="col-sm-3">
                                <label class="col-form-label"><?php echo $ipf[0]; ?>.<?php echo $ipf[1]; ?>.<?php echo $ipf[2]; ?>.<?php echo $ipf[3]; ?></label>
                                <input style="display: none" type="text" readonly name="ipf_1" id="ipf_1" value="<?php echo $ipf[0]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipf_2" id="ipf_2" value="<?php echo $ipf[1]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipf_3" id="ipf_3" value="<?php echo $ipf[2]; ?>"/>
                                <input style="display: none" type="text" readonly name="ipf_4" id="ipf_4" value="<?php echo $ipf[3]; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Rede:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" readonly name="rede" maxlength="70" value="<?php echo $dados_ip['rede']; ?>">
                                <input style="display: none" type="text" readonly name="cidr" id="cidr" value="<?php echo $ip->cidr(); ?>"/>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-danger">Apagar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>