<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_mon_.php";
    include "../var_sub.php";
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Apagar Monitor - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <h4>ATENÇÃO, OS DADOS SERÃO APAGADOS!!!</h4>
                    <form action="del_mon_.php" method="POST">
                        <?php
                            $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                            $busca_unid->bindValue(":id",$dados['unidade']);
                            $busca_unid->execute();
                            $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                            $busca_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE id=:id");
                            $busca_mod->bindValue(":id",$dados['modelo']);
                            $busca_mod->execute();
                            $dados_mod=$busca_mod->fetch(PDO::FETCH_ASSOC);
                            $busca_marc=$pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE id=:id");
                            $busca_marc->bindValue(":id",$dados_mod['marca']);
                            $busca_marc->execute();
                            $dados_marc=$busca_marc->fetch(PDO::FETCH_ASSOC);
                        ?>
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód.:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['cod_m']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados_unid['unidade']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Marca:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados_marc['marca']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados_mod['modelo']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Série:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" size="30" value="<?php echo $dados['nserie']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Data de Aquisição:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['daquise'])); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Termino da Garantia:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['garantia'])); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Loja</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['loja']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número da Nota Fiscal:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['nnota']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número do Imobilizado:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['nptri']; ?>">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-danger">Apagar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>