<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "alt_mod_.php";
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Alteração de Modelo - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form action="alt_mod_.php" method="POST">
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Marca:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="marca">
                                    <?php
                                        $busca = $pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE comp=:comp OR mon=:mon OR eqp=:eqp ORDER BY id");
                                        $busca->bindValue(":comp",'1');
                                        $busca->bindValue(":mon",'1');
                                        $busca->bindValue(":eqp",'1');
                                        $busca->execute();
                                        while ($linha = $busca->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['marca'] == $valor){echo ' selected';} echo ">$linha[marca]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control"  name="modelo" required maxlength="80" value="<?php echo $dados['modelo']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo">
                                    <option value="1" <?php if($dados['tipo'] == 1){echo ' selected';}?> >Computadores</option>
                                    <option value="2" <?php if($dados['tipo'] == 2){echo ' selected';}?> >Monitores</option>
                                    <option value="3" <?php if($dados['tipo'] == 3){echo ' selected';}?> >Equipamentos</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                        <button type="button" class="btn btn-danger" align="center" onclick="javascript: window.location.href='del_mod.php?id=<?php echo $del;?>';">Apagar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>