<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_geral.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
    $cont = 0;
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Processadores - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar</th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID</th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Marca</th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Modelo</th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Descrição do Modelo
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar_marc = $pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE proc=:proc ORDER BY marca");
                        $buscar_marc->bindValue(":proc",'1');
                        $buscar_marc->execute();
                        if($buscar_marc->rowCount() > 0){
                            while($ver_marc = $buscar_marc->fetch(PDO::FETCH_ASSOC)){
                                $ver_marc_ = $ver_marc['marca'];
                                $buscar = $pdo_sgt->prepare("SELECT * FROM tb_proc WHERE marca=:id ORDER BY proc");
                                $buscar->bindValue(":id",$ver_marc['id']);
                                $buscar->execute();
                                if($buscar->rowCount() > 0){
                                    while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                        $cont ++;
                                        echo'<tr align="center">'
                                            . '<td class="align-middle" scope="row" title="Editar">'
                                                . '<div class="mx-sm-1">'
                                                    . '<a href="alt_proc.php?id='.$ver['id'].'">'
                                                        . '<img title="Editar" src="../img/editar.png" height="15" width="15">'
                                                    . '</a>'
                                                . '</div>'
                                            . '</td>'
                                            . '<td class="align-middle" title="ID">'
                                                . '<div class="mx-sm-1">'
                                                    .$ver['id']
                                                . '</div>'
                                            .'</td>'
                                            . '<td class="align-middle" title="Marca">'
                                                . '<div class="mx-sm-1">'
                                                    .$ver_marc_
                                                . '</div>'
                                            .'</td>'
                                            . '<td class="align-middle" title="Modelo">'
                                                . '<div class="mx-sm-1">'
                                                    .$ver['proc']
                                                . '</div>'
                                            .'</td>'
                                            . '<td class="align-middle" title="Descrição do Modelo">'
                                                . '<div class="mx-sm-1">'
                                                    .$ver['des_proc']
                                                . '</div>'
                                            .'</td>'
                                        . '</tr>';
                                    }
                                }
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de processadores '.$cont.'</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>