<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_geral.php");
    protegePagina();
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Tipos - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Tipo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Computadores
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Equipamentos
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Monitores
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar = $pdo_sgt->query("SELECT * FROM tb_tipos ORDER BY tipo");
                        $cont = $buscar->rowCount();
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC))
                            {
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Editar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="alt_tipo.php?id='.$ver['id'].'">'
                                                . '<img title="Editar" src="../img/editar.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="ID">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['id']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Tipo">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['tipo']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Computadores">'
                                        . '<div class="mx-sm-1">'
                                            . '<input type="checkbox" disabled '; if($ver['comp'] != 0){echo 'CHECKED';} echo'>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Equipamentos">'
                                        . '<div class="mx-sm-1">'
                                            . '<input type="checkbox" disabled '; if($ver['eqp'] != 0){echo 'CHECKED';} echo'>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Monitores">'
                                        . '<div class="mx-sm-1">'
                                            . '<input type="checkbox" disabled '; if($ver['mon'] != 0){echo 'CHECKED';} echo'>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de tipos '.$buscar->rowCount().'</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>