<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm_av.php");
    protegePagina();
    include "../var_sub.php";
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Grupos de Captura - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="cad_voip_cap_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Unidade:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="unidade">
                            <option value = \"0\">Sem Seleção</option>
                                <?php
                                    if($unid_temp == 1){
                                        $busca_uni=$pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY unidade");
                                    } else {
                                        $busca_uni=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id ORDER BY unidade");
                                        $busca_uni->bindValue(":id",$unid_master);
                                    }
                                    $busca_uni->execute();
                                    while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                        $valor = $linha['id']; 
                                        echo "<option value = \"$valor\""; if($unid_master == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                    }
                                ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>ID Grupo:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="grup" maxlength="8" size="10" required >
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Nome do Grupo:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="nome" maxlength="20" size="20" required >
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID do Grupo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nome do Grupo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Apagar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_voip_cap ORDER BY unidade AND grup");
                        } else {
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_voip_cap WHERE unidade=:unidade ORDER BY unidade AND grup");
                            $buscar->bindValue(":unidade",$unid_master);
                        }
                        $buscar->execute();
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                $buscar_unid->bindValue(":id",$ver['unidade']);
                                $buscar_unid->execute();
                                $dados_unid = $buscar_unid->fetch(PDO::FETCH_ASSOC);
                                echo'<tr align="center" id="id'.$ver['id'].'">'
                                    . '<td class="align-middle" scope="row" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_unid['unidade']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="ID do Grupo">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['grup']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" scope="row" title="Nome do Grupo">'
                                        . '<div class="inp_div mx-sm-1">'
                                            . '<form action="alt_voip_cap_.php" method="POST">'
                                                . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                . '<input type="text" class="form-control-plaintext" size="30" name="nome" value="'.$ver['nome'].'">'
                                                . '<input style="display: none" type="submit" name="ok" value="" />'
                                            . '</form>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Apagar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="del_voip_cap.php?id='.$ver['id'].'">'
                                                . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot></tfoot>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>