<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm_av.php");
    protegePagina();
    include "../var_sub.php";
    $fun = 0;
    $cont = 0;
    $id_g = 1;
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de PIN - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="cad_voip_pin_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Unidade:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="unidade">
                                <?php
                                    if($unid_temp == 1){
                                        $busca_uni=$pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY unidade");
                                    } else {
                                        $busca_uni=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id ORDER BY unidade");
                                        $busca_uni->bindValue(":id",$unid_master);
                                    }
                                    $busca_uni->execute();
                                    while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                        $valor = $linha['id']; 
                                        echo "<option value = \"$valor\""; if($unid_master == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                    }
                                ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Funcionário:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="func">
                            <?php
                                $buscaf_u=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id ORDER BY unidade");
                                $buscaf_u->bindValue(":id",$unid_master);
                                $buscaf_u->execute();
                                while ($linhaf_u = $buscaf_u->fetch(PDO::FETCH_ASSOC)){
                                    $valorf_u = $linhaf_u['id'];
                                    $buscaf =$pdo_sgt->prepare("SELECT * FROM tb_funcionarios WHERE unidade=:unidade ORDER BY nome_c");
                                    $buscaf->bindValue(":unidade",$valorf_u);
                                    $buscaf->execute();
                                    while ($linhaf = $buscaf->fetch(PDO::FETCH_ASSOC)){
                                        $valorf = $linhaf['id'];
                                        echo "<option value = \"$valorf\">".$linhaf_u['unidade']." - ".$linhaf['p_nome']." ".$linhaf['u_nome']."</option>";
                                    }

                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>PIN:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="pin" maxlength="10" size="8" required >
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Particular:</label>
                    </div>
                    <div class="custom-control custom-checkbox">
                        <input class="custom-control-input" type="checkbox" id="part" name="part" value="ativo">
                        <label class="custom-control-label" for="part"></label>
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Funcionário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    PIN
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Particular
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Apagar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_voip_pin ORDER BY unidade,pin");
                        } else {
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_voip_pin WHERE unidade=:unidade ORDER BY unidade,pin");
                            $buscar->bindValue(":unidade",$unid_master);
                        }
                        $buscar->execute();
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                $buscar_unid->bindValue(":id",$ver['unidade']);
                                $buscar_unid->execute();
                                $dados_unid = $buscar_unid->fetch(PDO::FETCH_ASSOC);
                                if($ver['part'] != 1){
                                    $part_ = 'Não';
                                } else {
                                    $part_ = 'Sim';
                                }
                                echo'<tr align="center" id="id'.$ver['id'].'">'
                                    . '<td class="align-middle" scope="row" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_unid['unidade']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Funcionário">'
                                        . '<div class="inp_div mx-sm-1">'
                                                . '<form action="alt_voip_pin_func_.php" method="POST">'
                                                    . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                    . '<select class="custom-select form-control-sm" name="func">';
                                                        if ($unid_master == 1){
                                                            $busca_func=$pdo_sgt->prepare("SELECT DISTINCT t1.id, t2.unidade, t1.nome_c FROM tb_funcionarios t1 INNER JOIN tb_unidades t2 ON (t1.unidade = t2.id) ORDER BY t2.unidade, t1.nome_c");
                                                            $busca_func->execute();
                                                            while ($linha_func=$busca_func->fetch(PDO::FETCH_ASSOC)){
                                                                $valor_func = $linha_func['id'];
                                                                echo "<option value = \"$valor_func\""; if($ver['func'] == $valor_func){echo ' selected';} echo ">".$linha_func['unidade']." - ".$linha_func['nome_c']."</option>";
                                                            }
                                                        } else {
                                                            $busca_func=$pdo_sgt->prepare("SELECT DISTINCT t1.id, t2.unidade, t1.nome_c FROM tb_funcionarios t1 INNER JOIN tb_unidades t2 ON (t1.unidade = t2.id) WHERE t1.unidade=:unidade ORDER BY t2.unidade, t1.nome_c");
                                                            $busca_func->bindValue(":unidade",$unid_master);
                                                            $busca_func->execute();
                                                            while ($linha_func=$busca_func->fetch(PDO::FETCH_ASSOC)){
                                                                $valor_func = $linha_func['id'];
                                                                echo "<option value = \"$valor_func\""; if($ver['func'] == $valor_func){echo ' selected';} echo ">".$linha_func['unidade']." - ".$linha_func['nome_c']."</option>";
                                                            }
                                                        }
                                                    echo '</select>'
                                                    . '<button type="submit" class="btn btn-sm btn-primary mx-sm-1" title="Salvar">Salvar</button>'
                                                . '</form>'
                                            . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" scope="row" title="PIN">'
                                        . '<div class="inp_div mx-sm-1">'
                                            . '<form action="alt_voip_pin_.php" method="POST">'
                                                . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                . '<input type="text" class="form-control-plaintext" maxlength="10" size="8" name="pin" value="'.$ver['pin'].'">'
                                                . '<input style="display: none" type="submit" name="ok" value="" />'
                                            . '</form>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Funcionário">'
                                        . '<div class="mx-sm-1">'
                                            .$part_
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Apagar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="del_voip_pin.php?id='.$ver['id'].'">'
                                                . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot></tfoot>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>