<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_user_.php";
    include "../var_sub.php"; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Alteração de Usuário - SGT</title>
    <script>
        function verifica_forca(senha){
            forca = 0;
            mostra = document.getElementById("mostra");
            if((senha.length > 7) && (senha.length <= 12)){
                forca += 10;
            }else if((senha.length>12)){
                forca += 25;
            }
            if(senha.match(/[a-z]+/)){
                forca += 10;
            }
            if(senha.match(/[A-Z]+/)){
                forca += 20;
            }
            if(senha.match(/\d+/)){
                forca += 20;
            }
            if(senha.match(/\W+/)){
                forca += 25;
            }
            return mostra_res();
            return libera_aplicar();
        }
        function mostra_res(){
            if(forca <=30){
                mostra.innerHTML = '<label style="color:#FF0000;" width="'+forca+'"> Fraca </label>';
            }else if((forca > 30) && (forca < 60)){
                mostra.innerHTML = '<label style="color:#FFBE00;" width="'+forca+'"> Boa </label>'; 
            }else if((forca >= 60) && (forca < 85)){
                mostra.innerHTML = '<label style="color:#0000FF;" width="'+forca+'"> Forte </label>';
            }else {
                mostra.innerHTML = '<label style="color:#00CD00;" width="'+forca+'"> Excelente </label>';
            }
        }
        function verifica_iguais(){
            senha1=document.getElementById("senha");
            senha2=document.getElementById("csenha");

            iguais=document.getElementById("iguais");
            if(senha1.value==senha2.value){
                iguais.innerHTML = '<label style="color:#00CD00;"> Senhas digitadas são iguais. </label>';
            }else{
                iguais.innerHTML = '<label style="color:#FF0000;"> Senhas digitadas não são iguais. </label>';
            }
            return libera_aplicar();
        }
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form name="id" id="id" action="alt_user_.php" method="POST" onsubmit="return true">
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>"/>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nome:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nome" required maxlength="80" value="<?php echo $dados['nome']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Sobrenome:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="sobrenome" required maxlength="80" value="<?php echo $dados['sobrenome']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Usuário:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['usuario']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">e-Mail:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="email" required maxlength="100" value="<?php echo $dados['email']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Senha:</label>
                            <div class="col-sm-3">
                                <input type="password" class="form-control" placeholder="Senha" name="senha" id="senha" onkeyup="javascript:verifica_forca(this.value)">
                            </div> 
                            <label id="mostra"></label>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Confirmar Senha:</label>
                            <div class="col-sm-3">
                                <input type="password" class="form-control" placeholder="Confirma Senha" name="csenha" id="csenha" onkeyup="javascript:verifica_iguais()">
                            </div> 
                            <label id="iguais"></label>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">
                                    <?php
                                        $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY id");
                                        $busca_uni->execute();
                                        while (@$linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nível</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="nivel" >
                                <?php
                                    if($nivel == 1){
                                        echo '<option value="1"'; if($dados['nivel'] == 1){echo ' selected';} echo '>Máster</option>';
                                    }
                                ?>
                                <option value="2" <?php if($dados['nivel'] == 2){echo ' selected';}?> >Administrador</option>
                                <option value="3" <?php if($dados['nivel'] == 3){echo ' selected';}?> >Gerente Unidade</option>
                                <option value="4" <?php if($dados['nivel'] == 4){echo ' selected';}?> >Auxiliar Unidade</option>
                                <option value="5" <?php if($dados['nivel'] == 5){echo ' selected';}?> >Colaborador Geral</option>
                                <option value="6" <?php if($dados['nivel'] == 6){echo ' selected';}?> >Consultor Unidade</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Ativo</label>
                            <div class="col-sm-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="ativo" name="ativo" value="ativo" <?php if($dados['ativo'] != 0){echo ' CHECKED';} ?>>
                                    <label class="custom-control-label" for="ativo"></label>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                        <?php
                            if ($nivel == 1) {
                                echo '<button type="button" class="btn btn-danger" align="center" onclick="javascript: window.location.href'; echo "='del_user.php?id=".$del."';"; echo '">Apagar</button>';
                            }
                        ?>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div> 
</body>
</html>