<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Usuários - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nome
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Sobrenome
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Usuário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    e-mail
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nível
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Ativo
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $buscar = $pdo_sgt->query("SELECT * FROM tb_usuarios ORDER BY usuario");
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){ 
                                $busca_unid=$pdo_sgt->query("SELECT * FROM tb_unidades WHERE id='".$ver['unidade']."'");
                                $dados_unid = $busca_unid->fetch(PDO::FETCH_ASSOC);
                                switch($ver['nivel']) { case 1 : $nivel="Máster"; break; case 2 : $nivel="Administrador"; break; case 3 : $nivel="Gerente Unidade"; break; case 4 : $nivel="Auxiliar Unidade"; break; case 5 : $nivel="Colaborador Geral"; break; default: $nivel="Consultor Unidade"; }
                                if($ver['ativo']==1){$ativo="Ativo";}else{$ativo="Desativado";}
                                echo'<tr align="center" id="id'.$ver['id'].'">'
                                . '<td class="align-middle" scope="row" title="Editar - '.$ver['usuario'].'">'
                                    . '<div class="mx-sm-1">'
                                        . '<a href="alt_user.php?id='.$ver['id'].'">'
                                            . '<img title="Editar - '.$ver['usuario'].'" src="../img/editar.png" height="15" width="15">'
                                        . '</a>'
                                    . '</div>'
                                . '</td>'
                                . '<td class="align-middle" title="Nome">'
                                    . '<div class="mx-sm-1">'
                                        .$ver['nome']
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Sobrenome">'
                                    . '<div class="mx-sm-1">'
                                        .$ver['sobrenome']
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Usuário">'
                                    . '<div class="mx-sm-1">'
                                        .$ver['usuario']
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="e-mail">'
                                    . '<div class="mx-sm-1">'
                                        .$ver['email']
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Unidade">'
                                    . '<div class="mx-sm-1">'
                                        .$dados_unid['unidade']
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Nível">'
                                    . '<div class="mx-sm-1">'
                                        .$nivel
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Ativo">'
                                    . '<div class="mx-sm-1">'
                                        .$ativo
                                    . '</div>'
                                .'</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de usuários '.$buscar->rowCount().'</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>