-- MySQL dump 10.13  Distrib 5.7.17, for macos10.12 (x86_64)
--
-- Host: 127.0.0.1    Database: db_sgt
-- ------------------------------------------------------
-- Server version	5.5.5-10.1.36-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `tb_chaves`
--

DROP TABLE IF EXISTS `tb_chaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_chaves` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `produto` varchar(80) NOT NULL DEFAULT '',
  `chave` varchar(120) NOT NULL DEFAULT '',
  `nivel` int(6) NOT NULL,
  `unidade` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_chave_unidade` (`unidade`),
  CONSTRAINT `fk_chave_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_chaves`
--

LOCK TABLES `tb_chaves` WRITE;
/*!40000 ALTER TABLE `tb_chaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_chaves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_computadores`
--

DROP TABLE IF EXISTS `tb_computadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_computadores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cod_c` varchar(7) NOT NULL DEFAULT '',
  `unidade` int(6) NOT NULL,
  `tipo` int(6) NOT NULL,
  `modelo` int(6) NOT NULL,
  `nserie` varchar(80) NOT NULL DEFAULT '',
  `daquise` date DEFAULT NULL,
  `garantia` date DEFAULT NULL,
  `pmae` varchar(80) NOT NULL DEFAULT '',
  `proc` int(6) DEFAULT NULL,
  `nproc` int(4) NOT NULL,
  `ram` int(6) NOT NULL,
  `ram_clok` int(6) DEFAULT NULL,
  `hd` float NOT NULL,
  `tipo_hd` int(6) DEFAULT NULL,
  `desc_hd` varchar(120) NOT NULL DEFAULT '',
  `loja` varchar(80) NOT NULL DEFAULT '',
  `nnota` int(40) DEFAULT NULL,
  `valor` double NOT NULL,
  `nptri` varchar(40) NOT NULL DEFAULT '',
  `nlacre` int(20) DEFAULT NULL,
  `setor` int(6) DEFAULT NULL,
  `netbios` varchar(30) NOT NULL DEFAULT '',
  `mac_c` varchar(17) NOT NULL DEFAULT '',
  `mac_w` varchar(17) NOT NULL DEFAULT '',
  `sistema` int(6) DEFAULT NULL,
  `office` int(6) DEFAULT NULL,
  `plc_video` int(6) DEFAULT NULL,
  `nplc_video` int(4) NOT NULL,
  `cod_mon1` int(6) DEFAULT NULL,
  `cod_mon2` int(6) DEFAULT NULL,
  `desc_comp` text NOT NULL,
  `ativo` tinyint(4) NOT NULL DEFAULT '1',
  `f_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_comp_id` (`id`),
  KEY `idx_comp_cod_c` (`cod_c`),
  KEY `idx_comp_unidade` (`unidade`),
  KEY `idx_comp_tipo` (`tipo`),
  KEY `idx_comp_modelo` (`modelo`),
  KEY `idx_comp_setor` (`setor`),
  KEY `idx_comp_mac_c` (`mac_c`),
  KEY `idx_comp_mac_w` (`mac_w`),
  KEY `fk_comp_proc` (`proc`),
  KEY `fk_comp_ram_clok` (`ram_clok`),
  KEY `fk_comp_tipo_hd` (`tipo_hd`),
  KEY `fk_comp_sistema` (`sistema`),
  KEY `fk_comp_office` (`office`),
  KEY `fk_comp_plc_video` (`plc_video`),
  KEY `fk_comp_cod_mon1` (`cod_mon1`),
  KEY `fk_comp_cod_mon2` (`cod_mon2`),
  CONSTRAINT `fk_comp_cod_mon1` FOREIGN KEY (`cod_mon1`) REFERENCES `tb_monitores` (`id`),
  CONSTRAINT `fk_comp_cod_mon2` FOREIGN KEY (`cod_mon2`) REFERENCES `tb_monitores` (`id`),
  CONSTRAINT `fk_comp_modelo` FOREIGN KEY (`modelo`) REFERENCES `tb_modelos` (`id`),
  CONSTRAINT `fk_comp_office` FOREIGN KEY (`office`) REFERENCES `tb_offices` (`id`),
  CONSTRAINT `fk_comp_plc_video` FOREIGN KEY (`plc_video`) REFERENCES `tb_videos` (`id`),
  CONSTRAINT `fk_comp_proc` FOREIGN KEY (`proc`) REFERENCES `tb_proc` (`id`),
  CONSTRAINT `fk_comp_ram_clok` FOREIGN KEY (`ram_clok`) REFERENCES `tb_ram_clok` (`id`),
  CONSTRAINT `fk_comp_setor` FOREIGN KEY (`setor`) REFERENCES `tb_setores` (`id`),
  CONSTRAINT `fk_comp_sistema` FOREIGN KEY (`sistema`) REFERENCES `tb_sistemas` (`id`),
  CONSTRAINT `fk_comp_tipo` FOREIGN KEY (`tipo`) REFERENCES `tb_tipos` (`id`),
  CONSTRAINT `fk_comp_tipo_hd` FOREIGN KEY (`tipo_hd`) REFERENCES `tb_tipo_hd` (`id`),
  CONSTRAINT `fk_comp_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_computadores`
--

LOCK TABLES `tb_computadores` WRITE;
/*!40000 ALTER TABLE `tb_computadores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_computadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_conf`
--

DROP TABLE IF EXISTS `tb_conf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_conf` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `conf` varchar(20) NOT NULL DEFAULT '',
  `var1` varchar(100) NOT NULL DEFAULT '',
  `var2` varchar(100) NOT NULL DEFAULT '',
  `var3` varchar(100) NOT NULL DEFAULT '',
  `var4` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_conf_id` (`id`),
  KEY `idx_conf_conf` (`conf`),
  KEY `idx_conf_var1` (`var1`),
  KEY `idx_conf_var2` (`var2`),
  KEY `idx_conf_var3` (`var3`),
  KEY `idx_conf_var4` (`var4`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_conf`
--

LOCK TABLES `tb_conf` WRITE;
/*!40000 ALTER TABLE `tb_conf` DISABLE KEYS */;
INSERT INTO `tb_conf` VALUES (2,'rodape','','','',''),(3,'db_sgt','10.0.0','','','');
/*!40000 ALTER TABLE `tb_conf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_equipamentos`
--

DROP TABLE IF EXISTS `tb_equipamentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_equipamentos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cod_e` varchar(7) NOT NULL DEFAULT '',
  `unidade` int(6) NOT NULL,
  `tipo` int(6) NOT NULL,
  `setor` int(6) NOT NULL,
  `modelo` int(6) NOT NULL,
  `nserie` varchar(80) NOT NULL DEFAULT '',
  `daquise` date DEFAULT NULL,
  `garantia` date DEFAULT NULL,
  `mac_1` varchar(17) NOT NULL DEFAULT '',
  `loja` varchar(80) NOT NULL DEFAULT '',
  `nnota` varchar(40) NOT NULL DEFAULT '',
  `valor` double NOT NULL,
  `nptri` varchar(40) NOT NULL DEFAULT '',
  `desc_eqp` text NOT NULL,
  `ativo` tinyint(4) NOT NULL DEFAULT '1',
  `f_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_eqp_id` (`id`),
  KEY `idx_eqp_cod_e` (`cod_e`),
  KEY `idx_eqp_unidade` (`unidade`),
  KEY `idx_eqp_tipo` (`tipo`),
  KEY `idx_eqp_modelo` (`modelo`),
  KEY `idx_eqp_setor` (`setor`),
  KEY `idx_eqp_mac_1` (`mac_1`),
  CONSTRAINT `fk_eqp_modelo` FOREIGN KEY (`modelo`) REFERENCES `tb_modelos` (`id`),
  CONSTRAINT `fk_eqp_setor` FOREIGN KEY (`setor`) REFERENCES `tb_setores` (`id`),
  CONSTRAINT `fk_eqp_tipo` FOREIGN KEY (`tipo`) REFERENCES `tb_tipos` (`id`),
  CONSTRAINT `fk_eqp_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_equipamentos`
--

LOCK TABLES `tb_equipamentos` WRITE;
/*!40000 ALTER TABLE `tb_equipamentos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_equipamentos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_funcionarios`
--

DROP TABLE IF EXISTS `tb_funcionarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_funcionarios` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `setor` int(6) NOT NULL,
  `funcao` varchar(50) NOT NULL DEFAULT '',
  `p_nome` varchar(50) NOT NULL DEFAULT '',
  `u_nome` varchar(50) NOT NULL DEFAULT '',
  `nome_c` varchar(90) NOT NULL DEFAULT '',
  `email_1` varchar(100) NOT NULL DEFAULT '',
  `email_2` varchar(100) NOT NULL DEFAULT '',
  `tel_d` varchar(2) NOT NULL,
  `tel_p` varchar(4) NOT NULL,
  `tel_u` varchar(4) NOT NULL,
  `cel_d` varchar(2) NOT NULL,
  `cel_p` varchar(5) NOT NULL,
  `cel_u` varchar(4) NOT NULL,
  `cont` tinyint(4) NOT NULL DEFAULT '1',
  `ativo` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_func_id` (`id`),
  KEY `idx_func_unidade` (`unidade`),
  KEY `idx_func_setor` (`setor`),
  KEY `idx_func_p_nome` (`p_nome`),
  KEY `idx_func_u_nome` (`u_nome`),
  KEY `idx_func_nome_c` (`nome_c`),
  CONSTRAINT `fk_funcionario_setor` FOREIGN KEY (`setor`) REFERENCES `tb_setores` (`id`),
  CONSTRAINT `fk_funcionario_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_funcionarios`
--

LOCK TABLES `tb_funcionarios` WRITE;
/*!40000 ALTER TABLE `tb_funcionarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_funcionarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_hd_c`
--

DROP TABLE IF EXISTS `tb_hd_c`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_hd_c` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `de` int(6) NOT NULL,
  `dt_a` datetime DEFAULT NULL,
  `dt_f` datetime DEFAULT NULL,
  `produto` int(6) NOT NULL,
  `priori` int(6) NOT NULL,
  `para` int(6) NOT NULL,
  `resumo` varchar(255) NOT NULL,
  `descricao` text NOT NULL,
  `ver` tinyint(4) NOT NULL DEFAULT '1',
  `status` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_hd_c_id` (`id`),
  KEY `idx_hd_c_de` (`de`),
  KEY `idx_hd_c_para` (`para`),
  KEY `idx_hd_c_status` (`status`),
  KEY `fk_hd_c_produto` (`produto`),
  CONSTRAINT `fk_hd_c_de` FOREIGN KEY (`de`) REFERENCES `tb_usuarios` (`id`),
  CONSTRAINT `fk_hd_c_para` FOREIGN KEY (`para`) REFERENCES `tb_usuarios` (`id`),
  CONSTRAINT `fk_hd_c_produto` FOREIGN KEY (`produto`) REFERENCES `tb_hd_pro` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_hd_c`
--

LOCK TABLES `tb_hd_c` WRITE;
/*!40000 ALTER TABLE `tb_hd_c` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_hd_c` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_hd_e`
--

DROP TABLE IF EXISTS `tb_hd_e`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_hd_e` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `cha` int(6) NOT NULL,
  `de` int(6) NOT NULL,
  `dt` datetime DEFAULT NULL,
  `descricao` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_hd_e_id` (`id`),
  KEY `idx_hd_e_cha` (`cha`),
  KEY `fk_hd_e_de` (`de`),
  CONSTRAINT `fk_hd_e_chamado` FOREIGN KEY (`cha`) REFERENCES `tb_hd_c` (`id`),
  CONSTRAINT `fk_hd_e_de` FOREIGN KEY (`de`) REFERENCES `tb_usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_hd_e`
--

LOCK TABLES `tb_hd_e` WRITE;
/*!40000 ALTER TABLE `tb_hd_e` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_hd_e` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_hd_hist`
--

DROP TABLE IF EXISTS `tb_hd_hist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_hd_hist` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `cha` int(6) NOT NULL,
  `de` int(6) NOT NULL,
  `dt` datetime DEFAULT NULL,
  `hist` varchar(90) NOT NULL DEFAULT '',
  `alt` varchar(120) NOT NULL DEFAULT '',
  `status` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_hd_hist_id` (`id`),
  KEY `idx_hd_hist_cha` (`cha`),
  KEY `fk_hd_hist_de` (`de`),
  CONSTRAINT `fk_hd_hist_chamado` FOREIGN KEY (`cha`) REFERENCES `tb_hd_c` (`id`),
  CONSTRAINT `fk_hd_hist_de` FOREIGN KEY (`de`) REFERENCES `tb_usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_hd_hist`
--

LOCK TABLES `tb_hd_hist` WRITE;
/*!40000 ALTER TABLE `tb_hd_hist` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_hd_hist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_hd_pro`
--

DROP TABLE IF EXISTS `tb_hd_pro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_hd_pro` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `produto` varchar(90) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_hd_pro_id` (`id`),
  KEY `idx_hd_pro_produto` (`produto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_hd_pro`
--

LOCK TABLES `tb_hd_pro` WRITE;
/*!40000 ALTER TABLE `tb_hd_pro` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_hd_pro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_key`
--

DROP TABLE IF EXISTS `tb_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_key` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `descricao` varchar(80) NOT NULL DEFAULT '',
  `usuario` varchar(40) NOT NULL DEFAULT '',
  `senha` varchar(120) NOT NULL DEFAULT '',
  `nivel` int(6) NOT NULL,
  `unidade` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_key_unidade` (`unidade`),
  CONSTRAINT `fk_key_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_key`
--

LOCK TABLES `tb_key` WRITE;
/*!40000 ALTER TABLE `tb_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_local`
--

DROP TABLE IF EXISTS `tb_local`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_local` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `local` varchar(80) NOT NULL DEFAULT '',
  `descricao` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_local_id` (`id`),
  KEY `idx_local_local` (`local`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_local`
--

LOCK TABLES `tb_local` WRITE;
/*!40000 ALTER TABLE `tb_local` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_local` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_log`
--

DROP TABLE IF EXISTS `tb_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_log` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL,
  `ip` varchar(260) NOT NULL DEFAULT '',
  `user_id` int(6) NOT NULL,
  `user_nome` varchar(80) NOT NULL DEFAULT '',
  `log` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_log_user_id` (`user_id`),
  CONSTRAINT `fk_log_user_id` FOREIGN KEY (`user_id`) REFERENCES `tb_usuarios` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_log`
--

LOCK TABLES `tb_log` WRITE;
/*!40000 ALTER TABLE `tb_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_map_canal`
--

DROP TABLE IF EXISTS `tb_map_canal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_map_canal` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `local` int(6) NOT NULL,
  `sw` int(3) NOT NULL,
  `sw_pt` int(2) NOT NULL,
  `pp` int(3) NOT NULL,
  `pp_pt` int(2) NOT NULL,
  `pc_s` float NOT NULL,
  `link` float NOT NULL,
  `pc_d` float NOT NULL,
  `descricao` varchar(50) NOT NULL DEFAULT '',
  `cor` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_map_canal_id` (`id`),
  KEY `idx_map_canal_unidade` (`unidade`),
  KEY `idx_map_canal_local` (`local`),
  CONSTRAINT `fk_map_canal_local` FOREIGN KEY (`local`) REFERENCES `tb_local` (`id`),
  CONSTRAINT `fk_map_canal_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_map_canal`
--

LOCK TABLES `tb_map_canal` WRITE;
/*!40000 ALTER TABLE `tb_map_canal` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_map_canal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_map_ip`
--

DROP TABLE IF EXISTS `tb_map_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_map_ip` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `rede` varchar(80) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `cidr` int(2) NOT NULL,
  `grupo` varchar(80) NOT NULL DEFAULT '',
  `mac` varchar(17) NOT NULL DEFAULT '',
  `descricao` varchar(100) NOT NULL DEFAULT '',
  `cor` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_map_ip_id` (`id`),
  KEY `idx_map_ip_unidade` (`unidade`),
  KEY `idx_map_ip_ip` (`ip`),
  KEY `idx_map_ip_mac` (`mac`),
  CONSTRAINT `fk_mapa_ip_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_map_ip`
--

LOCK TABLES `tb_map_ip` WRITE;
/*!40000 ALTER TABLE `tb_map_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_map_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_marcas`
--

DROP TABLE IF EXISTS `tb_marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_marcas` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `marca` varchar(40) NOT NULL DEFAULT '',
  `comp` tinyint(4) NOT NULL DEFAULT '0',
  `mon` tinyint(4) NOT NULL DEFAULT '0',
  `eqp` tinyint(4) NOT NULL DEFAULT '0',
  `proc` tinyint(4) NOT NULL DEFAULT '0',
  `vid` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_marca_id` (`id`),
  KEY `idx_marca_marca` (`marca`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_marcas`
--

LOCK TABLES `tb_marcas` WRITE;
/*!40000 ALTER TABLE `tb_marcas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_modelos`
--

DROP TABLE IF EXISTS `tb_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_modelos` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `marca` int(6) NOT NULL,
  `modelo` varchar(80) NOT NULL DEFAULT '',
  `tipo` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_modelo_id` (`id`),
  KEY `idx_modelo_modelo` (`modelo`),
  KEY `fk_modelo_marca` (`marca`),
  CONSTRAINT `fk_modelo_marca` FOREIGN KEY (`marca`) REFERENCES `tb_marcas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_modelos`
--

LOCK TABLES `tb_modelos` WRITE;
/*!40000 ALTER TABLE `tb_modelos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_monitores`
--

DROP TABLE IF EXISTS `tb_monitores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_monitores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cod_m` varchar(7) NOT NULL DEFAULT '',
  `unidade` int(6) NOT NULL,
  `setor` int(6) NOT NULL,
  `modelo` int(6) NOT NULL,
  `nserie` varchar(80) NOT NULL DEFAULT '',
  `daquise` date DEFAULT NULL,
  `garantia` date DEFAULT NULL,
  `loja` varchar(80) NOT NULL DEFAULT '',
  `nnota` varchar(40) NOT NULL DEFAULT '',
  `valor` double NOT NULL,
  `nptri` varchar(40) NOT NULL DEFAULT '',
  `desc_mon` text NOT NULL,
  `ativo` tinyint(4) NOT NULL DEFAULT '1',
  `f_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_mon_id` (`id`),
  KEY `idx_mon_cod_m` (`cod_m`),
  KEY `idx_mon_unidade` (`unidade`),
  KEY `idx_mon_modelo` (`modelo`),
  KEY `idx_mon_setor` (`setor`),
  CONSTRAINT `fk_mom_modelo` FOREIGN KEY (`modelo`) REFERENCES `tb_modelos` (`id`),
  CONSTRAINT `fk_mom_setor` FOREIGN KEY (`setor`) REFERENCES `tb_setores` (`id`),
  CONSTRAINT `fk_mom_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_monitores`
--

LOCK TABLES `tb_monitores` WRITE;
/*!40000 ALTER TABLE `tb_monitores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_monitores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_oc_comp`
--

DROP TABLE IF EXISTS `tb_oc_comp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_oc_comp` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL,
  `user_nome` varchar(80) NOT NULL DEFAULT '',
  `cod_c` int(6) NOT NULL,
  `tipo` int(6) NOT NULL,
  `des` text,
  PRIMARY KEY (`id`),
  KEY `fk_oc_comp_cod_c` (`cod_c`),
  CONSTRAINT `fk_oc_comp_cod_c` FOREIGN KEY (`cod_c`) REFERENCES `tb_computadores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_oc_comp`
--

LOCK TABLES `tb_oc_comp` WRITE;
/*!40000 ALTER TABLE `tb_oc_comp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_oc_comp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_oc_eqp`
--

DROP TABLE IF EXISTS `tb_oc_eqp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_oc_eqp` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL,
  `user_nome` varchar(80) NOT NULL DEFAULT '',
  `cod_e` int(6) NOT NULL,
  `tipo` int(6) NOT NULL,
  `des` text,
  PRIMARY KEY (`id`),
  KEY `fk_oc_eqp_cod_e` (`cod_e`),
  CONSTRAINT `fk_oc_eqp_cod_e` FOREIGN KEY (`cod_e`) REFERENCES `tb_equipamentos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_oc_eqp`
--

LOCK TABLES `tb_oc_eqp` WRITE;
/*!40000 ALTER TABLE `tb_oc_eqp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_oc_eqp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_oc_mon`
--

DROP TABLE IF EXISTS `tb_oc_mon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_oc_mon` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL,
  `user_nome` varchar(80) NOT NULL DEFAULT '',
  `cod_m` int(6) NOT NULL,
  `tipo` int(6) NOT NULL,
  `des` text,
  PRIMARY KEY (`id`),
  KEY `fk_oc_mon_cod_m` (`cod_m`),
  CONSTRAINT `fk_oc_mon_cod_m` FOREIGN KEY (`cod_m`) REFERENCES `tb_monitores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_oc_mon`
--

LOCK TABLES `tb_oc_mon` WRITE;
/*!40000 ALTER TABLE `tb_oc_mon` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_oc_mon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_offices`
--

DROP TABLE IF EXISTS `tb_offices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_offices` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `office` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_office_id` (`id`),
  KEY `idx_office_office` (`office`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_offices`
--

LOCK TABLES `tb_offices` WRITE;
/*!40000 ALTER TABLE `tb_offices` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_offices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_pp`
--

DROP TABLE IF EXISTS `tb_pp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_pp` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `nivel` int(6) NOT NULL,
  `tt` varchar(60) NOT NULL DEFAULT '',
  `descricao` varchar(120) NOT NULL DEFAULT '',
  `pp` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_pp_unidade` (`unidade`),
  CONSTRAINT `fk_pp_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_pp`
--

LOCK TABLES `tb_pp` WRITE;
/*!40000 ALTER TABLE `tb_pp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_pp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_proc`
--

DROP TABLE IF EXISTS `tb_proc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_proc` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `marca` int(6) NOT NULL,
  `proc` varchar(80) NOT NULL DEFAULT '',
  `des_proc` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_proc_id` (`id`),
  KEY `idx_proc_proc` (`proc`),
  KEY `idx_proc_des_proc` (`des_proc`),
  KEY `fk_proc_marca` (`marca`),
  CONSTRAINT `fk_proc_marca` FOREIGN KEY (`marca`) REFERENCES `tb_marcas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_proc`
--

LOCK TABLES `tb_proc` WRITE;
/*!40000 ALTER TABLE `tb_proc` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_proc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_ram_clok`
--

DROP TABLE IF EXISTS `tb_ram_clok`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_ram_clok` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `clok` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ram_clok_id` (`id`),
  KEY `idx_ram_clok_clok` (`clok`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_ram_clok`
--

LOCK TABLES `tb_ram_clok` WRITE;
/*!40000 ALTER TABLE `tb_ram_clok` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_ram_clok` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_setores`
--

DROP TABLE IF EXISTS `tb_setores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_setores` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `setor` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_setor_id` (`id`),
  KEY `idx_setor_setor` (`setor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_setores`
--

LOCK TABLES `tb_setores` WRITE;
/*!40000 ALTER TABLE `tb_setores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_setores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_sistemas`
--

DROP TABLE IF EXISTS `tb_sistemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_sistemas` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `sistema` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_sistema_id` (`id`),
  KEY `idx_sistema_sistema` (`sistema`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_sistemas`
--

LOCK TABLES `tb_sistemas` WRITE;
/*!40000 ALTER TABLE `tb_sistemas` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_sistemas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_switch`
--

DROP TABLE IF EXISTS `tb_switch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_switch` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `sw` int(3) NOT NULL,
  `local` int(6) NOT NULL,
  `id_sw` int(6) NOT NULL,
  `status` varchar(120) NOT NULL DEFAULT '',
  `vlan` varchar(300) NOT NULL DEFAULT '',
  `tipo` varchar(120) NOT NULL DEFAULT '',
  `descricao` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_switch_local` (`local`),
  CONSTRAINT `fk_switch_local` FOREIGN KEY (`local`) REFERENCES `tb_local` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_switch`
--

LOCK TABLES `tb_switch` WRITE;
/*!40000 ALTER TABLE `tb_switch` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_switch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_tipo_hd`
--

DROP TABLE IF EXISTS `tb_tipo_hd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_tipo_hd` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(40) NOT NULL DEFAULT '',
  `disp` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_tipo_hd_id` (`id`),
  KEY `idx_tipo_hd_tipo` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_tipo_hd`
--

LOCK TABLES `tb_tipo_hd` WRITE;
/*!40000 ALTER TABLE `tb_tipo_hd` DISABLE KEYS */;
INSERT INTO `tb_tipo_hd` VALUES (1,'mSATA',0),(2,'mSATA2',0),(3,'SAS 2,5\"',0),(4,'SAS 3,5\"',0),(5,'SATA 2,5\"',0),(6,'SATA 3,5\"',0),(7,'SSD - SAS 2,5\"',0),(8,'SSD - SATA 2,5\"',0);
/*!40000 ALTER TABLE `tb_tipo_hd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_tipos`
--

DROP TABLE IF EXISTS `tb_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_tipos` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(40) NOT NULL DEFAULT '',
  `comp` tinyint(4) NOT NULL DEFAULT '0',
  `eqp` tinyint(4) NOT NULL DEFAULT '0',
  `mon` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tipo_id` (`id`),
  KEY `idx_tipo_tipo` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_tipos`
--

LOCK TABLES `tb_tipos` WRITE;
/*!40000 ALTER TABLE `tb_tipos` DISABLE KEYS */;
INSERT INTO `tb_tipos` VALUES (1,'All-In-One',1,0,0),(2,'Chromebook',1,0,0),(3,'Desktop',1,0,0),(4,'Notebook',1,0,0),(5,'Servidor',1,0,0),(6,'Tablet',1,0,0),(7,'Switch',0,1,0),(8,'Telefone VoIP',0,1,0);
/*!40000 ALTER TABLE `tb_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_unidades`
--

DROP TABLE IF EXISTS `tb_unidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_unidades` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `unidade` varchar(40) NOT NULL DEFAULT '',
  `dominio` varchar(60) NOT NULL DEFAULT '',
  `ddd` int(3) NOT NULL,
  `nome_pt1` varchar(80) NOT NULL DEFAULT '',
  `email_pt1` varchar(100) NOT NULL DEFAULT '',
  `nome_pt2` varchar(80) NOT NULL DEFAULT '',
  `email_pt2` varchar(100) NOT NULL DEFAULT '',
  `des_unid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_unidade_id` (`id`),
  KEY `idx_unidade_unidade` (`unidade`),
  KEY `idx_unidade_ddd` (`ddd`),
  KEY `idx_unidade_nome_pt1` (`nome_pt1`),
  KEY `idx_unidade_nome_pt2` (`nome_pt2`),
  KEY `idx_unidade_email_pt1` (`email_pt1`),
  KEY `idx_unidade_email_pt2` (`email_pt2`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_unidades`
--

LOCK TABLES `tb_unidades` WRITE;
/*!40000 ALTER TABLE `tb_unidades` DISABLE KEYS */;
INSERT INTO `tb_unidades` VALUES (1,'Geral','',0,'','','','','Acesso Total'),(2,'Estoque','',0,'','','','','Estoque Geral');
/*!40000 ALTER TABLE `tb_unidades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_usuarios`
--

DROP TABLE IF EXISTS `tb_usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_usuarios` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `usuario` varchar(40) NOT NULL DEFAULT '',
  `senha` varchar(128) NOT NULL DEFAULT '',
  `nome` varchar(80) NOT NULL DEFAULT '',
  `sobrenome` varchar(80) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `unidade` int(6) NOT NULL,
  `unid_temp` int(6) NOT NULL,
  `temp_0` varchar(100) NOT NULL DEFAULT '',
  `temp_1` varchar(100) NOT NULL DEFAULT '',
  `temp_2` varchar(100) NOT NULL DEFAULT '',
  `temp_3` varchar(100) NOT NULL DEFAULT '',
  `temp_4` varchar(100) NOT NULL DEFAULT '',
  `temp_5` varchar(100) NOT NULL DEFAULT '',
  `temp_6` varchar(100) NOT NULL DEFAULT '',
  `temp_7` varchar(100) NOT NULL DEFAULT '',
  `temp_8` varchar(100) NOT NULL DEFAULT '',
  `temp_9` varchar(100) NOT NULL DEFAULT '',
  `nivel` int(6) NOT NULL,
  `avancado` tinyint(4) NOT NULL DEFAULT '0',
  `ativo` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_usuario_id` (`id`),
  KEY `idx_usuario_usuario` (`usuario`),
  KEY `idx_usuario_nome` (`nome`),
  KEY `idx_usuario_sobrenome` (`sobrenome`),
  KEY `idx_usuario_email` (`email`),
  KEY `idx_usuario_unidade` (`unidade`),
  KEY `idx_usuario_unid_temp` (`unid_temp`),
  KEY `idx_usuario_nivel` (`nivel`),
  KEY `idx_usuario_avancado` (`avancado`),
  CONSTRAINT `fk_usuario_unid_temp` FOREIGN KEY (`unid_temp`) REFERENCES `tb_unidades` (`id`),
  CONSTRAINT `fk_usuario_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_usuarios`
--

LOCK TABLES `tb_usuarios` WRITE;
/*!40000 ALTER TABLE `tb_usuarios` DISABLE KEYS */;
INSERT INTO `tb_usuarios` VALUES (1,'admin','21232f297a57a5a743894a0e4a801fc3%&*@345SgT','Administrador','SGT','suporte@sgt.eti.br',1,1,'','','','','','','','','','',1,1,1);
/*!40000 ALTER TABLE `tb_usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_videos`
--

DROP TABLE IF EXISTS `tb_videos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_videos` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `marca` int(6) NOT NULL,
  `modelo` varchar(80) NOT NULL DEFAULT '',
  `des_vid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_video_id` (`id`),
  KEY `idx_video_modelo` (`modelo`),
  KEY `idx_video_des_vid` (`des_vid`),
  KEY `fk_video_marca` (`marca`),
  CONSTRAINT `fk_video_marca` FOREIGN KEY (`marca`) REFERENCES `tb_marcas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_videos`
--

LOCK TABLES `tb_videos` WRITE;
/*!40000 ALTER TABLE `tb_videos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_videos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_vlan`
--

DROP TABLE IF EXISTS `tb_vlan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_vlan` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `id_vlan` int(6) NOT NULL,
  `vlan` varchar(20) NOT NULL DEFAULT '',
  `descricao` varchar(80) NOT NULL DEFAULT '',
  `cor` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_vlan_id` (`id`),
  KEY `idx_vlan_vlan` (`vlan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_vlan`
--

LOCK TABLES `tb_vlan` WRITE;
/*!40000 ALTER TABLE `tb_vlan` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_vlan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_voip`
--

DROP TABLE IF EXISTS `tb_voip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_voip` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `setor` int(6) NOT NULL,
  `voip` int(6) NOT NULL,
  `senha` varchar(50) NOT NULL DEFAULT '',
  `tel_d` varchar(2) NOT NULL,
  `tel_p` varchar(4) NOT NULL,
  `tel_u` varchar(4) NOT NULL,
  `tt` int(6) NOT NULL,
  `ta` int(6) NOT NULL,
  `ts` varchar(40) NOT NULL DEFAULT '',
  `grup` int(6) NOT NULL,
  `eqp` int(6) NOT NULL,
  `info` varchar(90) NOT NULL DEFAULT '',
  `func` int(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_voip_id` (`id`),
  KEY `idx_voip_unidade` (`unidade`),
  KEY `idx_voip_setor` (`setor`),
  KEY `idx_voip_voip` (`voip`),
  KEY `fk_voip_ta_voip` (`ta`),
  KEY `fk_voip_voip_cap` (`grup`),
  KEY `fk_voip_eqp` (`eqp`),
  KEY `fk_voip_func` (`func`),
  CONSTRAINT `fk_voip_eqp` FOREIGN KEY (`eqp`) REFERENCES `tb_equipamentos` (`id`),
  CONSTRAINT `fk_voip_func` FOREIGN KEY (`func`) REFERENCES `tb_funcionarios` (`id`),
  CONSTRAINT `fk_voip_setor` FOREIGN KEY (`setor`) REFERENCES `tb_setores` (`id`),
  CONSTRAINT `fk_voip_ta_voip` FOREIGN KEY (`ta`) REFERENCES `tb_voip` (`id`),
  CONSTRAINT `fk_voip_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`),
  CONSTRAINT `fk_voip_voip_cap` FOREIGN KEY (`grup`) REFERENCES `tb_voip_cap` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_voip`
--

LOCK TABLES `tb_voip` WRITE;
/*!40000 ALTER TABLE `tb_voip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_voip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_voip_cap`
--

DROP TABLE IF EXISTS `tb_voip_cap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_voip_cap` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `grup` int(3) NOT NULL,
  `nome` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_voip_cap_id` (`id`),
  KEY `idx_voip_cap_grup` (`grup`),
  KEY `fk_voip_cap_unidade` (`unidade`),
  CONSTRAINT `fk_voip_cap_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_voip_cap`
--

LOCK TABLES `tb_voip_cap` WRITE;
/*!40000 ALTER TABLE `tb_voip_cap` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_voip_cap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_voip_pin`
--

DROP TABLE IF EXISTS `tb_voip_pin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_voip_pin` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `unidade` int(6) NOT NULL,
  `func` int(6) NOT NULL,
  `pin` varchar(10) NOT NULL,
  `part` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_voip_pin_id` (`id`),
  KEY `idx_voip_pin_spin` (`pin`),
  KEY `fk_voip_pin_unidade` (`unidade`),
  KEY `fk_voip_pin_func` (`func`),
  CONSTRAINT `fk_voip_pin_func` FOREIGN KEY (`func`) REFERENCES `tb_funcionarios` (`id`),
  CONSTRAINT `fk_voip_pin_unidade` FOREIGN KEY (`unidade`) REFERENCES `tb_unidades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_voip_pin`
--

LOCK TABLES `tb_voip_pin` WRITE;
/*!40000 ALTER TABLE `tb_voip_pin` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_voip_pin` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-02-03 20:55:48
