<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    if($_SERVER['REQUEST_METHOD']=='GET'){
        $busca=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE id=:id");
        $busca->bindValue(":id",$_GET['id']);
        $busca->execute();
        $dados=$busca->fetch(PDO::FETCH_ASSOC);
        $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
        $busca_unid->bindValue(":id",$dados['unidade']);
        $busca_unid->execute();
        $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
        $busca_local=$pdo_sgt->prepare("SELECT * FROM tb_local WHERE id=:id");
        $busca_local->bindValue(":id",$dados['local']);
        $busca_local->execute();
        $dados_local=$busca_local->fetch(PDO::FETCH_ASSOC);
    }
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Apagar Canal - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <nav>
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                            <a class="nav-item nav-link active" id="nav-ponto-tab" data-toggle="tab" href="#nav-ponto" role="tab" aria-controls="nav-ponto" aria-selected="true">Apaga Ponto</a>
                            <a class="nav-item nav-link" id="nav-switch-tab" data-toggle="tab" href="#nav-switch" role="tab" aria-controls="nav-switch" aria-selected="false">Apaga Switch</a>
                            <a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact" role="tab" aria-controls="nav-contact" aria-selected="false">Apaga Patch Panel</a>
                        </div>
                    </nav>
                    <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="nav-ponto" role="tabpanel" aria-labelledby="nav-ponto-tab">
                            <h4>Apaga Apenas Ponto</h4>
                            <form action="del_canal_pt_.php" method="POST">
                                <input style="display: none" type="text" name="id" id="id" value="<?php echo $dados['id']; ?>">
                                <input style="display: none" type="text" name="pt" id="pt" value="<?php echo $dados['sw']; ?>/<?php echo $dados['sw_pt']; ?>-<?php echo $dados['pp']; ?>/<?php echo $dados['pp_pt']; ?>">
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Unidade: <?php echo $dados_unid['unidade']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Local: <?php echo $dados_local['local']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Switch: <?php echo $dados['sw']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Switch: <?php echo $dados['sw_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Patch Panel: <?php echo $dados['pp']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Patch Panel: <?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Ponto: <?php echo $dados['sw']; ?>/<?php echo $dados['sw_pt']; ?>-<?php echo $dados['pp']; ?>/<?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Descição: <?php echo $dados['descricao']; ?></label>
                                </div>
                                <button type="submit" class="btn btn-danger">Apagar Ponto</button>
                                <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.location.href='list_canal.php';">Cancelar</button>
                            </form>
                        </div>
                        <div class="tab-pane fade" id="nav-switch" role="tabpanel" aria-labelledby="nav-switch-tab">
                            <h4>Apaga Todo Switch</h4>
                            <form action="del_canal_sw_.php" method="POST">
                                <input style="display: none" type="text" name="id" id="id" value="<?php echo $dados['id']; ?>">
                                <input style="display: none" type="text" name="local" id="local" value="<?php echo $dados['local']; ?>">
                                <input style="display: none" type="text" name="sw" id="sw" value="<?php echo $dados['sw']; ?>">
                                <input style="display: none" type="text" name="pt" id="pt" value="<?php echo $dados['sw']; ?>/<?php echo $dados['sw_pt']; ?>-<?php echo $dados['pp']; ?>/<?php echo $dados['pp_pt']; ?>">
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Unidade: <?php echo $dados_unid['unidade']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Local: <?php echo $dados_local['local']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Switch: <?php echo $dados['sw']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Switch: <?php echo $dados['sw_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Patch Panel: <?php echo $dados['pp']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Patch Panel: <?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Ponto: <?php echo $dados['sw']; ?>/<?php echo $dados['sw_pt']; ?>-<?php echo $dados['pp']; ?>/<?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Descição: <?php echo $dados['descricao']; ?></label>
                                </div>
                                <button type="submit" class="btn btn-danger">Apagar Switch</button>
                                <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.location.href='list_canal.php';">Cancelar</button>
                            </form>
                        </div>
                        <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                            <h4>Apagar Todo Patch Panel</h4>
                            <form action="del_canal_pp_.php" method="POST">
                                <input style="display: none" type="text" name="unidade" id="unidade" value="<?php echo $dados['unidade']; ?>">
                                <input style="display: none" type="text" name="local" id="local" value="<?php echo $dados['local']; ?>">
                                <input style="display: none" type="text" name="pp" id="pp" value="<?php echo $dados['pp']; ?>">
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Unidade: <?php echo $dados_unid['unidade']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Local: <?php echo $dados_local['local']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Switch: <?php echo $dados['sw']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Switch: <?php echo $dados['sw_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Patch Panel: <?php echo $dados['pp']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Porta do Patch Panel: <?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Ponto: <?php echo $dados['sw']; ?>/<?php echo $dados['sw_pt']; ?>-<?php echo $dados['pp']; ?>/<?php echo $dados['pp_pt']; ?></label>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm col-form-label">Descição: <?php echo $dados['descricao']; ?></label>
                                </div>
                                <button type="submit" class="btn btn-danger">Apagar Patch Panel</button>
                                <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.location.href='list_canal.php';">Cancelar</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>