<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var.php";
    $fun = 0;
    $cont = 0;
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Listar Log- SGT</title>
</head>
<div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="table-responsive-sm tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Data
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    IP
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID do Usuário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Usuário
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Log
                                </div>
                            </th>
                        </tr>
                    </thead>
                <tbody>
                <?php 
                    //Define a variável recebida (p=página. via URL, exemplo: home.php?p=1)
                    $p = $_GET["p"];
                    // Verifica se a variável tá declarada, senão deixa
                    //na primeira página como padrão.
                    if(!isset($p)) $p = 1;
                    // Define aqui a quantidade máxima de registros por página.
                    $qnt = 25;
                    // A função calcula o início da seleção, calculando:
                    // (página atual * quantidade por página) - quantidade por página
                    $inicio = ($p*$qnt) - $qnt;
                    // Seleciona no banco de dados com o LIMIT indicado pelos
                    //números acima.
                    $sql_select = "SELECT * FROM tb_log ORDER BY id DESC LIMIT $inicio, $qnt";
                    // Executa o Query
                    $sql_query = $pdo_sgt->query($sql_select);
                    // Faz uma nova seleção no banco de dados, desta vez sem LIMIT para
                    //pegarmos o número total de registros
                    $sql_select_all = "SELECT * FROM tb_log ORDER BY id DESC";
                    // Executa o query da seleção acima
                    $sql_query_all = $pdo_sgt->query($sql_select_all);
                    // Gera uma variável com o número total de registros no banco de dados
                    $total_registros = $sql_query_all->rowCount();
                    // Gera outra variável, desta vez com o número de
                    //páginas que será preciso. O comando ceil() arredonda
                    //"para cima" o valor
                    $pags = ceil($total_registros/$qnt);
                    // Número máximos de botões de paginação
                    $max_links = 19;
                    // Exibe registro inicial
                    $reg_inicial = ($inicio+1);
                    //Exibe registro final
                    $reg_final = ($reg_inicial + 9);
                    if ($reg_final > $total_registros){
                    $reg_final = $total_registros;
                    }else{
                        $reg_final = ($reg_inicial + 9);};
                        // Cria um while para pegar as informações do BD
                        while($array = $sql_query->fetch(PDO::FETCH_ASSOC)) {
                        // Variável para capturar os campos no banco de dados
                            $id_ = $array["id"];
                            $dt_ = $array["dt"];
                            $ip_ = $array["ip"];
                            $user_id_ = $array["user_id"];
                            $user_nome_ = $array["user_nome"];
                            $log_ = $array["log"];
                            echo'<tr align="center">'
                                . '<td class="align-middle" scope="row" title="ID">'
                                    . '<div class="mx-sm-1">'
                                        .$id_
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Data e Horário">'
                                    . '<div class="mx-sm-1">'
                                        .date('d/m/Y H:i:s', strtotime($dt_))
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="IP de Origem">'
                                    . '<div class="mx-sm-1">'
                                        .$ip_
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="ID do Usuário">'
                                    . '<div class="mx-sm-1">'
                                        .$user_id_
                                    . '</div>'
                                .'</td>'
                                . '<td class="align-middle" title="Nome do Usuário">'
                                    . '<div class="mx-sm-1">'
                                        .$user_nome_
                                    . '</div>'
                                .'</td>'
                                . '<td  class="align-middle" align="left" title="LOG">'
                                    . '<div class="mx-sm-1">'
                                        .$log_
                                    . '</div>'
                                .'</td>'
                            . '</tr>';
                        }
                        echo'</tbody>';
                        echo'</table>';
                        // Depois que selecionou todos os campos, pula uma
                        //linha para exibir os links(próxima, última...)
                        echo "<br />";
                        //Se a página for =1 o link fica desativado
                        if ($p == 1){
                            echo '<nav aria-label="Page navigation example">'
                                . '<ul class="pagination pagination-sm justify-content-center">'
                                  . '<li class="page-item"><a class="page-link" href="#">Primeira página</a></li>';
                        } else {
                        // Exibe o primeiro link "primeira página", que não
                        //entra na contagem acima($max_links=5)
                        echo '<nav aria-label="Page navigation example">'
                                . '<ul class="pagination pagination-sm justify-content-center">'
                                  . '<li class="page-item"><a class="page-link" href="list_log.php?p=1">Primeira página</a></li>';
                    };
                    // Cria um for() para exibir os 3 links antes da página atual
                    for($i = $p-$max_links; $i <= $p-1; $i++) {
                    // Se o número da página for menor ou igual a zero, não faz nada
                    // (afinal, não existe página 0, -1, -2..)
                        if($i <=0) {
                        //faz nada
                        // Se estiver tudo OK, cria o link para outra página
                        } else {
                            echo '<li class="page-item"><a class="page-link" href="list_log.php?p='.$i.'">'.$i.'</a></li>';
                        }
                    }
                    // Exibe a página atual, sem link, apenas o número
                    echo '<li class="page-item active"><a class="page-link" href="list_log.php?p='.$i.'">'.$i.' <span class="sr-only">(current)</span></a></li>';
                    // Cria outro for(), desta vez para exibir 3 links após a página atual
                    for($i = $p+1; $i <= $p+$max_links; $i++) {
                    // Verifica se a página atual é maior do que
                    //a última página. Se for, não faz nada.
                    if($i > $pags) {
                    //faz nada
                    }
                    // Se tiver tudo Ok gera os links.
                    else {
                        echo '<li class="page-item"><a class="page-link" href="list_log.php?p='.$i.'">'.$i.'</a></li>';
                    }

                    }
                    //Se a página for igual a $pags o link fica desativado
                    if ($p == $pags){
                                echo '<li class="page-item"><a class="page-link" href="list_log.php?p='.$pags.'">Última página</a></li>'
                            . '</ul>'
                        . '</nav>';
                    } else {
                        // Exibe o link "última página"
                                echo '<li class="page-item"><a class="page-link" href="list_log.php?p='.$pags.'">Última página</a></li>'
                            . '</ul>'
                        . '</nav>';
                    }
                ?> 
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>