<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    $t_nivel = $nivel - 1;
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Lista de Passo a Passo - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <?php
                                if($nivel < 4){
                                    echo '<th scope="col">'
                                        . '<div class="mx-sm-1">'
                                            . 'Nível'
                                        . '</div>'
                                    . '</th>';
                                }
                            ?>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Título
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Descrição
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Ver
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_pp WHERE nivel>:nivel ORDER BY unidade,tt");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->execute();
                        } else {
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_pp WHERE nivel>:nivel AND ( unidade=:unidade1 OR unidade=:unidade2 ) ORDER BY unidade,tt");
                            $buscar->bindValue(":nivel",$t_nivel);
                            $buscar->bindValue(":unidade1",$unid_master);
                            $buscar->bindValue(":unidade2",1);
                            $buscar->execute();
                        }
                        if($buscar->rowCount() > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                if($ver['unidade'] != 0){
                                    if($_SERVER['REQUEST_METHOD']){
                                        $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                        $buscar_unid->bindValue(":id",$ver['unidade']);
                                        $buscar_unid->execute();
                                        $dados_unid=$buscar_unid->fetch(PDO::FETCH_ASSOC);
                                        $unid_tb=$dados_unid['unidade'];
                                    }
                                } else {
                                    $unid_tb = "Geral";
                                }
                                switch($ver['nivel']) { case 1 : $nivel_tb="Máster"; break; case 2 : $nivel_tb="Administrador"; break; case 3 : $nivel_tb="Gerente Unidade"; break; default: $nivel_tb="Auxiliar Unidade"; }
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$unid_tb
                                        . '</div>'
                                    . '</td>';
                                    if($nivel < 4){
                                        echo '<td class="align-middle" title="Nível">'
                                            . '<div class="mx-sm-1">'
                                                .$nivel_tb
                                            . '</div>'
                                        . '</td>';
                                    }
                                    echo '<td class="align-middle" title="Título">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['tt']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Descrição">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['descricao']
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Editar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="ver_pp.php?id='.$ver['id'].'">'
                                                . '<img title="Ver - '.$ver['tt'].'" src="../img/ver.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Editar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="alt_pp.php?id='.$ver['id'].'">'
                                                . '<img title="Editar - '.$ver['tt'].'" src="../img/editar.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de Chaves '.$buscar->rowCount().'</table>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>