<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
    $fun = 0;
    $cont = 0;
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function proximoCampo(atual,proximo){
            if(atual.value.length >= atual.maxLength){
                document.getElementById(proximo).focus();
            }
        }
    </script>
    <meta charset="UTF-8">
    <title>Gestão de Funcionários - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="cad_func_.php" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Unidade:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="unidade">
                        <option value = \"0\">Sem Seleção</option>
                            <?php
                                if($unid_temp == 1){
                                    $sqlu = "SELECT * FROM tb_unidades ORDER BY unidade";
                                } else {
                                    $sqlu = "SELECT * FROM tb_unidades WHERE id='".$unid_master."' ORDER BY unidade";
                                }
                                $busca_uni = $pdo_sgt->prepare($sqlu);
                                $busca_uni->execute();
                                while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                    $valor = $linha['id']; 
                                    echo "<option value = \"$valor\""; if($unid_master == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Setor:</label>
                        <select class="custom-select form-control-sm mx-sm-1" name="setor">
                        <option value = \"0\">Sem Seleção</option>
                            <?php
                                $busca_set = $pdo_sgt->query("SELECT * FROM tb_setores ORDER BY setor");
                                while ($linha = $busca_set->fetch(PDO::FETCH_ASSOC)){
                                    $valor = $linha['id']; 
                                    echo "<option value = \"$valor\">$valor - $linha[setor]</option>";
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Função:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="funcao">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Nome:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="p_nome" required>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Sobrenome:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" name="u_nome" required>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Nome Completo:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" size="30" name="nome_c" required>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>e-mail 1:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="email" size="30" name="email_1">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>e-mail 2:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="email" size="30" name="email_2">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Telefone:</label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" maxlength="2" size="1" name="tel_d" id="tel_d" onkeyup="javascript:proximoCampo(this, 'tel_1')">
                        <input class="form-control form-control-sm mx-sm-1" type="text" maxlength="4" size="2" name="tel_1" id="tel_1" onkeyup="javascript:proximoCampo(this,  'tel_2')">
                        -<input class="form-control form-control-sm mx-sm-1" type="text" maxlength="4" size="2" name="tel_2" id="tel_2" onkeyup="javascript:proximoCampo(this, 'cel_d')">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Celular: </label>
                        <input class="form-control form-control-sm mx-sm-1" type="text" maxlength="2" size="1" name="cel_d" id="cel_d" onkeyup="javascript:proximoCampo(this, 'cel_1')">
                        <input class="form-control form-control-sm mx-sm-1" type="text" maxlength="5" size="3" name="cel_1" id="cel_1" onkeyup="javascript:proximoCampo(this, 'cel_2')">
                        -<input class="form-control form-control-sm mx-sm-1" type="text" maxlength="4" size="2" name="cel_2" id="cel_2" onkeyup="javascript:proximoCampo(this, 'cont')">
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Só Contato:</label>
                    </div>
                    <div class="custom-control custom-checkbox">
                        <input class="custom-control-input" type="checkbox" id="cont" name="cont" value="ativo">
                        <label class="custom-control-label" for="cont"></label>
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Cadastrar</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered" width=2500px>
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Editar
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Setor
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Função
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nome
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Sobrenome
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Nome completo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    e-mail 1
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    e-mail 2
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Telefone
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Celular
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    VoIP
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    DDR
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Status
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            $buscar_query = ("SELECT * FROM tb_funcionarios ORDER BY nome_c");
                        } else {
                            $buscar_query = ("SELECT * FROM tb_funcionarios WHERE unidade='".$unid_master."' OR unidade='0' ORDER BY nome_c");
                        }
                        $buscar = $pdo_sgt->query($buscar_query);
                        $cont = $buscar->rowCount();
                        if($cont > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $busca_voip=$pdo_sgt->query("SELECT * FROM tb_voip WHERE func='".$ver['id']."'");
                                $dados_voip = $busca_voip->fetch(PDO::FETCH_ASSOC);
                                if($ver['unidade'] != 0){
                                    $busca_unid=$pdo_sgt->query("SELECT * FROM tb_unidades WHERE id='".$ver['unidade']."'");
                                    $dados_unid = $busca_unid->fetch(PDO::FETCH_ASSOC);
                                } else {
                                    $unidade_ = "Sem Unidade";
                                }
                                $busca_setor=$pdo_sgt->query("SELECT * FROM tb_setores WHERE id='".$ver['setor']."'");
                                $dados_setor = $busca_setor->fetch(PDO::FETCH_ASSOC);
                                if($ver['ativo']==1){$status="Ativo";}else{$status="Desativado";}
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Editar">'
                                        . '<div class="mx-sm-1">'
                                            . '<a href="alt_func.php?id='.$ver['id'].'">'
                                                . '<img title="Editar" src="../img/editar.png" height="15" width="15">'
                                            . '</a>'
                                        . '</div>'
                                    . '</td>'
                                    . '<td class="align-middle" title="Unidade">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_unid['unidade']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Setor">'
                                        . '<div class="mx-sm-1">'
                                            .$dados_setor['setor']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Função">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['funcao']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Nome">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['p_nome']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Sobrenome">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['u_nome']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Nome completo">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['nome_c']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="e-mail 1">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['email_1']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="e-mail 2">'
                                        . '<div class="mx-sm-1">'
                                            .$ver['email_2']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Telefone">'
                                        . '<div class="mx-sm-1">'
                                            . '('.$ver['tel_d'].') '.$ver['tel_p'].'-'.$ver['tel_u']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Calular">'
                                        . '<div class="mx-sm-1">'
                                            . '('.$ver['cel_d'].') '.$ver['cel_p'].'-'.$ver['cel_u']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="VoIP">'
                                        . '<div class="mx-sm-1">'
                                            . '*5 ('.$dados_unid['ddd'].') '.$dados_voip['voip']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="DDR">'
                                        . '<div class="mx-sm-1">'
                                            . '('.$dados_voip['tel_d'].') '.$dados_voip['tel_p'].'-'.$dados_voip['tel_u']
                                        . '</div>'
                                    .'</td>'
                                    . '<td class="align-middle" title="Status">'
                                        . '<div class="mx-sm-1">'
                                            .$status
                                        . '</div>'
                                    .'</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>';
                        echo'<tfoot>Contagem de funcionarios '.$cont.'</tfoot>';
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>