<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Help Desk - Abre Chamado - SGT</title>
    <script src="../tinymce/tinymce.min.js"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea',
            height: 300,
            theme: 'modern',
            language: 'pt_BR',
            mobile: {
                theme: 'beta-mobile',
                plugins: [ 'autosave' ]
            },
            plugins: 'code print preview fullpage searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists textcolor wordcount imagetools contextmenu colorpicker',
            toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',
            image_advtab: true,
            browser_spellcheck: true,
            contextmenu: false
        });
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col align-self-center">
                    <form method="POST" action="hd_abre_.php">
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Produto:</label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="pro">
                                    <?php
                                        $busca_prod = $pdo_sgt->prepare("SELECT * FROM tb_hd_pro ORDER BY produto");
                                        $busca_prod->execute();
                                        while (@$linha_prod = $busca_prod->fetch(PDO::FETCH_ASSOC)){ 
                                            $valor_prod = $linha_prod[@id];
                                            echo "<option value = \"$valor_prod\">$linha_prod[produto] </option>";
                                        }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Prioridade:</label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="prio">
                                    <option value="1">Baixa</option>
                                    <option value="2">Normal</option>
                                    <option value="3">Alta</option>
                                    <option value="4">Crítica</option>
                                </select>
                            </div>
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Público:</label>
                                <input type="checkbox" name="ver" value="ver" CHECKED>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Atribuído para:</label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="atri">
                                    <?php
                                    $busca_unid = $pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY unidade");
                                    $busca_unid->execute();
                                    while (@$linha_unid = $busca_unid->fetch(PDO::FETCH_ASSOC)){
                                        $valor_unid = $linha_unid[@id];
                                        $busca_user = $pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE unidade=:unidade AND nivel<:nivel AND ativo=:ativo ORDER BY nome, sobrenome");
                                        $busca_user->bindValue(":unidade",$valor_unid);
                                        $busca_user->bindValue(":nivel",5);
                                        $busca_user->bindValue(":ativo",1);
                                        $busca_user->execute();
                                        while (@$linha_user = $busca_user->fetch(PDO::FETCH_ASSOC)){
                                            $valor_user = $linha_user[@id];
                                            echo "<option value = \"$valor_user\">$linha_unid[unidade] - $linha_user[nome] $linha_user[sobrenome]</option>";
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Resumo:</label>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <input class="form-control form-control-sm mx-sm-1" type="text" size="80" name="resumo" required>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Descrição:</label>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <textarea name="desc"></textarea>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <p class="text-left">Todos os campos devem ser preenchidos.</p>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Abrir</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.location.href='list_hd.php';">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>