<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "hd_ate_.php";
    include "../var_sub.php";
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Help Desk - Atender Chamado - SGT</title>
    <script src="../tinymce/tinymce.min.js"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea',
            height: 300,
            theme: 'modern',
            language: 'pt_BR',
            mobile: {
                theme: 'beta-mobile',
                plugins: [ 'autosave' ]
            },
            plugins: 'code print preview fullpage searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists textcolor wordcount imagetools contextmenu colorpicker',
            toolbar1: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat',
            image_advtab: true,
            browser_spellcheck: true,
            contextmenu: false
        });
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col align-self-center">
                    <form action="hd_ate_.php" method="POST">
                        <div class="form-group row col-sm-12">
                            <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>" />
                            
                                <?php echo '<label class="col-form-label">Relator: '.$dados_unid['unidade'].' - '.$dados_user['nome'].' '.$dados_user['sobrenome'].'</label>'; ?>
                            
                            <div class="form-group mx-sm-1 mb-1">
                                <?php echo '<label class="col-form-label">Data de Abertura: '.date('d/m/Y H:i:s', strtotime($dados['dt_a'])).'</label>'; ?>
                            </div>
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="col-form-label">Produto:</label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="pro">
                                    <?php
                                        $qry = $pdo_sgt->query("SELECT * FROM tb_hd_pro ORDER BY produto");
                                        while (@$linha = $qry->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($dados['produto'] == $valor){echo ' selected';} echo ">$linha[produto]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="mb-1">
                                <label>Prioridade: </label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="prio">
                                    <option value="1"<?php if($dados['priori'] == 1){echo 'selected';} ?>>Baixa</option>
                                    <option value="2"<?php if($dados['priori'] == 2){echo 'selected';} ?>>Normal</option>
                                    <option value="3"<?php if($dados['priori'] == 3){echo 'selected';} ?>>Alta</option>
                                    <option value="4"<?php if($dados['priori'] == 4){echo 'selected';} ?>>Crítica</option>
                                </select>
                            </div>
                            <div class="mx-sm-1 mb-1">
                                <label>Público: </label>
                                <input type="checkbox" name="ver" <?php if($dados['ver'] != 0){echo ' CHECKED';}?>>
                            </div>
                            <div class="form-group mx-sm-1 mb-1">
                                <label class="form-label">Atribuído para: </label>
                                <select class="custom-select custom-select-sm mr-sm-2" name="atri">
                                    <?php
                                        $busca_unid = $pdo_sgt->prepare("SELECT * FROM tb_unidades ORDER BY unidade");
                                        $busca_unid->execute();
                                        while (@$linha_unid = $busca_unid->fetch(PDO::FETCH_ASSOC)){
                                            $valor_unid = $linha_unid[@id];
                                            $busca_user = $pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE unidade=:unidade AND nivel<:nivel AND ativo=:ativo ORDER BY nome, sobrenome");
                                            $busca_user->bindValue(":unidade",$valor_unid);
                                            $busca_user->bindValue(":nivel",5);
                                            $busca_user->bindValue(":ativo",1);
                                            $busca_user->execute();
                                            while (@$linha_user = $busca_user->fetch(PDO::FETCH_ASSOC)){
                                                $valor_user = $linha_user[@id];
                                                echo "<option value = \"$valor_user\""; if($dados['para'] == $valor_user){echo 'selected';} echo ">$linha_unid[unidade] - $linha_user[nome] $linha_user[sobrenome]</option>";
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <label class="font-weight-bold">Resumo: </label>
                        </div>
                        <div class="form-group row col-sm-12">
                            <span class="text-left"><?php echo $dados['resumo']; ?></span>
                        </div>
                        <div class="form-group row col-sm-12">
                            <label class="font-weight-bold">Descrição:</label>
                        </div>
                        <div class="form-group row col-sm-12">  
                            <span class="text-left"><?php echo $dados['descricao']; ?></span>
                        </div>
                        <div class="form-group row col-sm-12">
                            <div class="form-group mx-sm-1 mb-1">
                                <label>Histórico das Notas: </label>
                                <?php
                                    echo'<table class="table table-responsive table-sm table-bordered">';
                                    echo'<tbody>';
                                    $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_e WHERE cha=:cha ORDER BY id");
                                    $buscar->bindValue(":cha",$dados['id']);
                                    $buscar->execute();
                                    if($buscar->rowCount() > 0){
                                        while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                            $buscar_user_h=$pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE id=:id");
                                            $buscar_user_h->bindValue(":id",$ver['de']);
                                            $buscar_user_h->execute();
                                            $dados_user_h = $buscar_user_h->fetch(PDO::FETCH_ASSOC);
                                            $buscar_unid_h=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                            $buscar_unid_h->bindValue(":id",$dados_user_h['unidade']);
                                            $buscar_unid_h->execute();
                                            $dados_unid_h = $buscar_unid->fetch(PDO::FETCH_ASSOC);
                                            echo'<tr>'
                                                . '<td scope="row">'
                                                    . '<div class="mx-sm-1">'
                                                        . '<label>Relator: '.$dados_unid_h['unidade'].' - '.$dados_user_h['nome'].' '.$dados_user_h['sobrenome'].'</label>'
                                                        . '<label>Data de Abertura: '.date('d/m/Y H:i:s', strtotime($ver['dt'])).'</label>'
                                                    . '</div>'
                                                . '</td>'
                                                    . '<div class="mx-sm-1">'
                                                        . '<td>'.$ver['descricao'].'</td>'
                                                    . '</div>'
                                            . '</tr>';
                                        }
                                    }
                                    echo'</tbody>';
                                    echo'</table>'; 
                                ?>
                            </div>
                        </div>
                        <div class="form-group row col-sm-12">
                            <label>Nota: </label>
                        </div>
                        <div class="form-group row col-sm-12">
                            <textarea name="desc"></textarea>
                        </div>
                        <div class="form-group row col-sm-2">
                            <label>Status: </label>
                            <select class="custom-select custom-select-sm mr-sm-2" name="status">';
                                <option value="1" <?php if($dados['status'] == 1){echo 'selected';} ?>>Aguardando</option>
                                <option value="2" <?php if($dados['status'] == 2){echo 'selected';} ?>>Em Andamento</option>
                                <option value="3" <?php if($dados['status'] == 3){echo 'selected';} ?>>Pausa</option>
                                <option value="4" <?php if($dados['status'] == 4){echo 'selected';} ?>>Encerrado</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Salvar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.location.href='list_hd.php?p=1';">Cancelar</button>
                    </form>
                    <div class="table-responsive-sm  tab_sgt content_tb_sgt container">
                        <h6>Histórico do Chamado:</h6>
                        <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                            <thead>
                                <tr align="center" bgcolor=#B8DAFF>
                                    <th>
                                        <div class="mx-sm-1">
                                            Data
                                        </div>
                                    </th>
                                    <th>
                                        <div class="mx-sm-1">
                                            Usuário
                                        </div>
                                    </th>
                                    <th>
                                        <div class="mx-sm-1">
                                            Campo
                                        </div>
                                    </th>
                                    <th>
                                        <div class="mx-sm-1">
                                            Alteração
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_hist WHERE cha=:cha ORDER BY id");
                            $buscar->bindValue(":cha",$dados['id']);
                            $buscar->execute();
                            if($buscar->rowCount() > 0){
                                while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                    $buscar_user=$pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE id=:id");
                                    $buscar_user->bindValue(":id",$ver['de']);
                                    $buscar_user->execute();
                                    $dados_user = $buscar_user->fetch(PDO::FETCH_ASSOC);
                                    $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                    $buscar_unid->bindValue(":id",$dados_user['unidade']);
                                    $buscar_unid->execute();
                                    $dados_unid = $buscar_unid->fetch(PDO::FETCH_ASSOC);
                                    echo'<tr align="center">'
                                        . '<td class="align-middle" scope="row" title="Data">'
                                            . '<div class="mx-sm-1">'
                                                .date('d/m/Y H:i:s', strtotime($ver['dt']))
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Usuário">'
                                            . '<div class="mx-sm-1">'
                                                .$dados_unid['unidade'].' - '.$dados_user['nome'].' '.$dados_user['sobrenome']
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Campo">'
                                            . '<div class="mx-sm-1">'
                                                .$ver['hist']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Alteração">'
                                            . '<div class="mx-sm-1">'
                                                .$ver['alt']
                                            . '</div>'
                                        . '</td>'
                                    . '</tr>';
                                }
                            }else{
                                echo'Sem alterações!<br>';
                            }
                            echo'</tbody>';
                            echo'</table>';
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>