<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca.php");
    protegePagina();
    include "../var_sub.php";
    $pro_tp = $_SESSION['usuarioTemp_9'];
    if($pro_tp != $temp['temp_9']){
        $pro_tp = $temp['temp_9'];
    }
    $cont = 0;
?>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Help Desk - Buscar Chamados - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="list_dom.php?p=b" method="POST">
                    <div class="form-group mx-sm-1 mb-1">
                            <label>Dominio:</label>
                            <input class="form-control form-control-sm mx-sm-1" type="text" size="30" name="dom" required>
                    </div>
                    <button type="submit" class="btn btn-primary mx-sm-1">Pesquisar</button>
                </form>
                <form class="form-inline" action="alt_filtro_hd_pro_.php" method="POST">
                    <input style="display: none" type="text" readonly name="id" value="<?php echo $id_temp; ?>">
                    <div class="mx-sm-1">
                        <label>Produto:</label>
                    </div>
                    <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control-sm" name="pro">
                        <option value = \"a\">Sem Seleção</option>
                            <?php
                                $qry_pro = $pdo_sgt->query("SELECT * FROM tb_hd_pro ORDER BY produto");
                                while (@$linha_pro = $qry_pro->fetch(PDO::FETCH_ASSOC)){
                                    $valor_pro = $linha_pro[@id]; 
                                    echo "<option value = \"$valor_pro\""; if($pro_tp == $valor_pro){echo ' selected';} echo ">$linha_pro[produto] </option>";
                                }
                            ?>
                        </select>
                    <input type="submit" name="ok" value="Aplica filtro" />
                </form>
            </div>
            <div class="table-responsive-sm tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Chamado
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Relator
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Data de Abertura
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Atribuído
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Produto
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Prioridade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Resumo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Status
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Visibilidade
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            if($p != "b"){
                                if($nivel > 1){
                                    if($pro_tp == 0){
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE ver=:ver ORDER BY status,id");
                                        $buscar->bindValue(":ver",4);
                                        $buscar->execute();
                                    } else {
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE produto=:produto AND ver=:ver ORDER BY status,id");
                                        $buscar->bindValue(":ver",4);
                                        $buscar->bindValue(":produto",$pro_tp);
                                        $buscar->execute();
                                    }
                                } else {
                                    if($pro_tp == 0){
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c ORDER BY status,id");
                                        $buscar->execute();
                                    } else {
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE produto=:produto ORDER BY status,id");
                                        $buscar->bindValue(":produto",$pro_tp);
                                        $buscar->execute();
                                    }
                                }
                            } else {
                                if($nivel > 1){
                                    if($pro_tp == 0){
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE ver=:ver ORDER BY status,id");
                                        $buscar->bindValue(":ver",4);
                                        $buscar->execute();
                                    } else {
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE produto=:produto AND ver=:ver ORDER BY status,id");
                                        $buscar->bindValue(":ver",4);
                                        $buscar->bindValue(":produto",$pro_tp);
                                        $buscar->execute();
                                    }
                                } else {
                                    if($pro_tp == 0){
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c ORDER BY status,id");
                                        $buscar->execute();
                                    } else {
                                        $buscar=$pdo_sgt->prepare("SELECT * FROM tb_hd_c WHERE produto=:produto ORDER BY status,id");
                                        $buscar->bindValue(":produto",$pro_tp);
                                        $buscar->execute();
                                    }
                                }
                            }
                            if($buscar->rowCount() > 0){
                                while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                    $ver_tp = "";
                                    $pri_tp = "";
                                    $sta_tp = "";
                                    $buscar_user=$pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE id=:id");
                                    $buscar_user->bindValue(":id",$ver['de']);
                                    $buscar_user->execute();
                                    $dados_user = $buscar_user->fetch(PDO::FETCH_ASSOC);
                                    $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                    $buscar_unid->bindValue(":id",$dados_user['unidade']);
                                    $buscar_unid->execute();
                                    $dados_unid = $buscar_unid->fetch(PDO::FETCH_ASSOC);
                                    $buscar_user_=$pdo_sgt->prepare("SELECT * FROM tb_usuarios WHERE id=:id");
                                    $buscar_user_->bindValue(":id",$ver['para']);
                                    $buscar_user_->execute();
                                    $dados_user_ = $buscar_user_->fetch(PDO::FETCH_ASSOC);
                                    $buscar_unid_=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                    $buscar_unid_->bindValue(":id",$dados_user_['unidade']);
                                    $buscar_unid_->execute();
                                    $dados_unid_ = $buscar_unid_->fetch(PDO::FETCH_ASSOC);
                                    $buscar_pro=$pdo_sgt->prepare("SELECT * FROM tb_hd_pro WHERE id=:id");
                                    $buscar_pro->bindValue(":id",$ver['produto']);
                                    $buscar_pro->execute();
                                    $dados_pro = $buscar_pro->fetch(PDO::FETCH_ASSOC);
                                    if ($ver['ver'] == 1){ $ver_tp = "Público"; } else { $ver_tp = "Privado"; }
                                    switch($ver['priori']) { case 1 : $pri_tp="Baixa"; break; case 2 : $pri_tp="Normal"; break; case 3 : $pri_tp="Alta"; break; default: $pri_tp="Crítica"; }
                                    switch($ver['status']) { case 1 : $sta_tp="Aguardando"; break; case 2 : $sta_tp="Em Andamento"; break; case 3 : $sta_tp="Pausa"; break; default: $sta_tp="Encerrado"; }
                                    echo'<tr align="center">'
                                        . '<td class="align-middle" scope="row" title="Caso">'
                                            . '<div class="mx-sm-1">'
                                                . '<a href="hd_ate.php?id='.$ver['id'].'">'.$ver['id'].'</a>'
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Relator">'
                                            . '<div class="mx-sm-1">'
                                                . $dados_unid['unidade'].' - '.$dados_user['nome'].' '.$dados_user['sobrenome']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Data de Abertura">'
                                            . '<div class="mx-sm-1">'
                                                .date('d/m/Y H:i:s', strtotime($ver['dt_a'])).'&ensp;</td>'
                                            . '</div>'
                                        . '<td class="align-middle" title="Atribuído">'
                                            . '<div class="mx-sm-1">'
                                                .$dados_unid_['unidade'].' - '.$dados_user_['nome'].' '.$dados_user_['sobrenome']
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Produto">'
                                            . '<div class="mx-sm-1">'
                                                .$dados_pro['produto']
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Prioridade">'
                                            . '<div class="mx-sm-1">'
                                                .$pri_tp
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Resumo">'
                                            . '<div class="mx-sm-1">'
                                                .$ver['resumo']
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Status">'
                                            . '<div class="mx-sm-1">'
                                                .$sta_tp
                                            . '</div>'
                                        .'</td>'
                                        . '<td class="align-middle" title="Visibilidade">'
                                            . '<div class="mx-sm-1">'
                                                .$ver_tp
                                            . '</div>'
                                        . '</td>'
                                    . '</tr>';
                                }
                            }else{
                                echo'Sem dados cadastrais<br>';
                            }
                        echo'</tbody>';
                    ?>   
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>

