<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include"../seguranca_aux_unid.php";
    include "../var_sub.php";
    $rede_temp = $_SESSION['usuarioTemp_0'];
    if($rede_temp != $temp['temp_0']){
        $rede_temp = $temp['temp_0'];
    }
    $gru_temp = $_SESSION['usuarioTemp_1'];
    if($gru_temp != $temp['temp_1']){
        $gru_temp = $temp['temp_1'];
    }
    $valor_rede = 0;
    $valor_gru = 0;
    $valor_grup = 0;
    $fun = 0;
    $cont = 0;
    $comp = ' ';
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de IPs da Unidade - SGT</title>
    <script type=”text/javascript” src=”../js/jquery.min.js”></script>
    <script type=”text/javascript”>
        $(function() {
            $(‘ul li a’).bind(‘click’,function(event){
                var $anchor = $(this);
                $(‘html, body’).stop().animate({
                    scrollLeft: $($anchor.attr(‘href’)).offset().left
                }, 1000);
                event.preventDefault();
            });
        })
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="tb_div_unid_comp_f">
                <form name="id" id="id" action="alt_ip_gru_cor_.php" method="POST">
                    <input style="display: none" type="text" readonly name="unidade" value="<?php echo $unid_master; ?>" />
                    <label>ID Início: </label><input type="text" name="i" required>
                    <label>ID Fim: </label><input type="text" name="f" required>
                    <label>Grupo: </label><input type="text" name="grup">
                    <label>Cor: </label><input type="color" name="cor" value="#FFFFFF">
                    <input type="submit" name="ok" value="Salvar" />
                </form>
            </div>
            <div class="tb_div_unid_comp_f">
                <form class="form-inline" action="alt_filtro_.php" method="POST">
                    <input style="display: none" type="text" readonly name="id" value="<?php echo $id_temp; ?>" />
                    <div class="form-group mb-1">
                        <label>Filtra Rede: </label>
                        <select class="custom-select form-control-sm mx-sm-1" name="rede">
                            <option value = "4" <?php if($gru_temp == "4"){echo 'selected';} ?>>Sem Seleção</option>
                            <?php
                                if($unid_temp === 1){
                                    $busca_r = $pdo_sgt->prepare("SELECT DISTINCT rede FROM tb_map_ip ORDER BY rede");
                                    $busca_r->execute();
                                } else {
                                    $busca_r = $pdo_sgt->prepare("SELECT DISTINCT rede FROM tb_map_ip WHERE unidade=:unidade ORDER BY rede");
                                    $busca_r->bindValue(":unidade",$unid_master);
                                    $busca_r->execute();
                                }
                                while ($linha_r = $busca_r->fetch(PDO::FETCH_ASSOC)){
                                    $valor_r = $linha_r['rede'];
                                    echo "<option value = \"$valor_r\""; if($rede_temp == $valor_r){echo ' selected';} echo ">$valor_r</option>\n";
                                }
                            ?>
                        </select>
                    </div>
                    <div class="form-group mx-sm-1 mb-1">
                        <label>Filtra Grupo: </label>
                        <select class="custom-select form-control-sm mx-sm-1" name="gru">
                            <option value = "4" <?php if($gru_temp == "4"){echo ' selected';} ?>>Sem Seleção</option>
                            <?php
                                if($unid_master === 1){
                                    if($rede_temp != 4){
                                        $busca_g = $pdo_sgt->prepare("SELECT DISTINCT grupo FROM tb_map_ip WHERE rede=:rede ORDER BY grupo");
                                        $busca_g->bindValue(":rede",$rede_temp);
                                        $busca_g->execute();
                                    } else {
                                        $busca_g = $pdo_sgt->prepare("SELECT DISTINCT grupo FROM tb_map_ip ORDER BY grupo");
                                        $busca_g->execute();
                                    }
                                } else {
                                    if($rede_temp != 4){
                                        $busca_g = $pdo_sgt->prepare("SELECT DISTINCT grupo FROM tb_map_ip WHERE unidade=:unidade AND rede=:rede ORDER BY grupo");
                                        $busca_g->bindValue(":unidade",$unid_master);
                                        $busca_g->bindValue(":rede",$rede_temp);
                                        $busca_g->execute();
                                    } else {
                                        $busca_g = $pdo_sgt->prepare("SELECT DISTINCT grupo FROM tb_map_ip WHERE unidade=:unidade ORDER BY grupo");
                                        $busca_g->bindValue(":unidade",$unid_master);
                                        $busca_g->execute();
                                    }
                                }
                                while ($linha_g = $busca_g->fetch(PDO::FETCH_ASSOC)){
                                    $valor_g = $linha_g['grupo'];
                                    echo "<option value = \"$valor_g\""; if($gru_temp == $valor_g){echo ' selected';} echo ">$valor_g</option>\n";
                                }
                            ?>
                            <option value = "" <?php if($gru_temp == ""){echo ' selected';} ?>></option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary mx-sm-1">Aplica filtro</button>
                </form>
            </div>
            <div class="table-responsive-sm  tab_sgt content_tb_sgt">
                <table class="table-responsive-xl table-hover table-condensed table-bordered">
                    <thead>
                        <tr align="center" bgcolor=#B8DAFF>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    ID
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Unidade
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Rede
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Grupo
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    IP / CIDR
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    MAC
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Descrição
                                </div>
                            </th>
                            <th scope="col">
                                <div class="mx-sm-1">
                                    Dispositivo
                                </div>
                            </th>
                            <?php
                                if ($unid_temp == 1 && $nivel == 1) {
                                    echo '<th scope="col">'
                                        . '<div class="mx-sm-1">'
                                            . 'Apagar'
                                        . '</div>'
                                    . '</th>';
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        if($unid_master == 1){
                            if($rede_temp != 4){
                                if($gru_temp != 4){
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE rede=:rede AND grupo=:grupo ORDER BY id");
                                    $buscar->bindValue(":rede",$rede_temp);
                                    $buscar->bindValue(":grupo",$gru_temp);
                                    $buscar->execute();
                                } else {
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE rede=:rede ORDER BY id");
                                    $buscar->bindValue(":rede",$rede_temp);
                                    $buscar->execute();
                                }
                            } else {
                                if($gru_temp != 4){
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE grupo=:grupo ORDER BY id");
                                    $buscar->bindValue(":grupo",$gru_temp);
                                    $buscar->execute();
                                } else {
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip ORDER BY id");
                                    $buscar->execute();
                                }
                            }
                        } else {
                            if($rede_temp != 4){
                                if($gru_temp != 4){
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE unidade=:unidade AND rede=:rede AND grupo=:grupo ORDER BY id,unidade,rede");
                                    $buscar->bindValue(":unidade",$unid_master);
                                    $buscar->bindValue(":rede",$rede_temp);
                                    $buscar->bindValue(":grupo",$gru_temp);
                                    $buscar->execute();
                                } else {
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE unidade=:unidade AND rede=:rede ORDER BY id,unidade,rede");
                                    $buscar->bindValue(":unidade",$unid_master);
                                    $buscar->bindValue(":rede",$rede_temp);
                                    $buscar->execute();
                                }
                            } else {
                                if($gru_temp != 4){
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE unidade=:unidade AND grupo=:grupo ORDER BY id,unidade,rede");
                                    $buscar->bindValue(":unidade",$unid_master);
                                    $buscar->bindValue(":grupo",$gru_temp);
                                    $buscar->execute();
                                } else {
                                    $buscar = $pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE unidade=:unidade ORDER BY id,unidade,rede");
                                    $buscar->bindValue(":unidade",$unid_master);
                                    $buscar->execute();
                                }
                            }
                        }
                        $cont = $buscar->rowCount();
                        if($cont > 0){
                            while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                                $buscar_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                $buscar_unid->bindValue(":id",$ver['unidade']);
                                $buscar_unid->execute();
                                $dados_unid=$buscar_unid->fetch(PDO::FETCH_ASSOC);
                                if($ver['mac'] != "" || $ver['mac'] != null){
                                    $buscar_mac_c=$pdo_sgt->prepare("SELECT * FROM tb_computadores WHERE mac_c=:mac_c");
                                    $buscar_mac_c->bindValue(":mac_c",$ver['mac']);
                                    $buscar_mac_c->execute();
                                    $dados_mac_c=$buscar_mac_c->fetch(PDO::FETCH_ASSOC);
                                    $buscar_mac_w=$pdo_sgt->prepare("SELECT * FROM tb_computadores WHERE mac_w=:mac_w");
                                    $buscar_mac_w->bindValue(":mac_w",$ver['mac']);
                                    $buscar_mac_w->execute();
                                    $dados_mac_w=$buscar_mac_w->fetch(PDO::FETCH_ASSOC);
                                    $buscar_eqp=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE mac_1=:mac_1");
                                    $buscar_eqp->bindValue(":mac_1",$ver['mac']);
                                    $buscar_eqp->execute();
                                    $dados_eqp=$buscar_eqp->fetch(PDO::FETCH_ASSOC);
                                }
                                if($ver['cor'] === "" || $ver['cor'] === null){
                                    echo'<tr align="center" id="id'.$ver['id'].'">'
                                        . '<td class="align-middle" scope="row" title="ID">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . $ver['id']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Unidade">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . $dados_unid['unidade']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Rede">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['rede']
                                            . '</div>'
                                        . '</td>'
                                            . '<td class="align-middle" title="Grupo">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['grupo']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Grupo">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['ip'].' / '.$ver['cidr']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="MAC">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . '<form name="id" id="id" action="alt_ip_mac_.php" method="POST">'
                                                    . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                    . '<input type="text" class="form-control-plaintext" name="mac" value="'.$ver['mac'].'" maxlength="17" size="17">'
                                                    . '<input style="display: none" type="submit" name="ok" value="" />'
                                                . '</form>'
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Descrição">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . '<form name="id" id="id" action="alt_ip_desc_.php" method="POST">'
                                                    . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                    . '<input type="text" class="form-control-plaintext" name="desc" value="'.$ver['descricao'].'" maxlength="80" size="17">'
                                                    . '<input style="display: none" type="submit" name="ok" value="" />'
                                                . '</form>'
                                            . '</div>'
                                        . '</td>';
                                        if($ver['mac'] == "" || $ver['mac'] == null){
                                            echo'<td></td>';
                                        } else {
                                            if($dados_mac_c['netbios'] == ""){
                                                if($dados_mac_w['netbios'] == ""){
                                                    if($dados_eqp['cod_e'] == ""){
                                                        echo'<td></td>';
                                                    } else {
                                                        echo'<td class="align-middle" title="Grupo">'
                                                            . '<div class="mx-sm-1">'
                                                                . $dados_eqp['cod_e']
                                                            . '</div>'
                                                        .'</td>';
                                                    }
                                                } else {
                                                    echo'<td class="align-middle" title="Grupo">'
                                                        . '<div class="mx-sm-1">'
                                                            . $dados_mac_w['netbios'].' - Wi-Fi'
                                                        . '</div>'
                                                    .'</td>';
                                                }
                                            } else {
                                                echo'<td class="align-middle" title="Grupo">'
                                                    . '<div class="mx-sm-1">'
                                                        . $dados_mac_c['netbios'].' - Cabo'
                                                    . '</div>'
                                                .'</td>';
                                            }
                                        }
                                        if ($unid_temp == 1 && $nivel == 1) {
                                            echo'<td>'
                                                . '<div class="mx-sm-1">'
                                                    . '<a href="del_ip_unid.php?id='.$ver['id'].'">'
                                                        . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                                    . '</a>'
                                                . '</div>'
                                            . '</td>';
                                        }
                                    echo '</tr>';
                                } else {
                                    echo'<tr align="center" bgcolor='.$ver['cor'].' id="id'.$ver['id'].'">'
                                        . '<td class="align-middle" scope="row" title="ID">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . $ver['id']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Unidade">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . $dados_unid['unidade']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Rede">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['rede']
                                            . '</div>'
                                        . '</td>'
                                            . '<td class="align-middle" title="Grupo">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['grupo']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Grupo">'
                                            . '<div class="mx-sm-1">'
                                                . $ver['ip'].' / '.$ver['cidr']
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="MAC">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . '<form name="id" id="id" action="alt_ip_mac_.php" method="POST">'
                                                    . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                    . '<input type="text" class="form-control-plaintext" name="mac" value="'.$ver['mac'].'" maxlength="17" size="17">'
                                                    . '<input style="display: none" type="submit" name="ok" value="" />'
                                                . '</form>'
                                            . '</div>'
                                        . '</td>'
                                        . '<td class="align-middle" title="Descrição">'
                                            . '<div class="inp_div mx-sm-1">'
                                                . '<form name="id" id="id" action="alt_ip_desc_.php" method="POST">'
                                                    . '<input style="display: none" type="text" readonly name="id" value="'.$ver['id'].'" />'
                                                    . '<input type="text" class="form-control-plaintext" name="desc" value="'.$ver['descricao'].'" maxlength="80" size="17">'
                                                    . '<input style="display: none" type="submit" name="ok" value="" />'
                                                . '</form>'
                                            . '</div>'
                                        . '</td>';
                                        if($ver['mac'] == "" || $ver['mac'] == null){
                                            echo'<td></td>';
                                        } else {
                                            if($dados_mac_c['netbios'] == ""){
                                                if($dados_mac_w['netbios'] == ""){
                                                    if($dados_eqp['cod_e'] == ""){
                                                        echo'<td></td>';
                                                    } else {
                                                        echo'<td class="align-middle" title="Grupo">'
                                                            . '<div class="mx-sm-1">'
                                                                . $dados_eqp['cod_e']
                                                            . '</div>'
                                                        .'</td>';
                                                    }
                                                } else {
                                                    echo'<td class="align-middle" title="Grupo">'
                                                        . '<div class="mx-sm-1">'
                                                            . $dados_mac_w['netbios'].' - Wi-Fi'
                                                        . '</div>'
                                                    .'</td>';
                                                }
                                            } else {
                                                echo'<td class="align-middle" title="Grupo">'
                                                    . '<div class="mx-sm-1">'
                                                        . $dados_mac_c['netbios'].' - Cabo'
                                                    . '</div>'
                                                .'</td>';
                                            }
                                        }
                                        if ($unid_temp == 1 && $nivel == 1) {
                                            echo'<td>'
                                                . '<div class="mx-sm-1">'
                                                    . '<a href="del_ip_unid.php?id='.$ver['id'].'">'
                                                        . '<img title="Apagar" src="../img/lixo.png" height="15" width="15">'
                                                    . '</a>'
                                                . '</div>'
                                            . '</td>';
                                        }
                                    echo '</tr>';
                                }
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo"</tbody>"
                        . "<tfoot>Contagem de IP's ".$cont."</tfoot>";
                    ?>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>