<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var_sub.php";
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function proximoCampo(atual,proximo){
            if(atual.value.length >= atual.maxLength){
                document.getElementById(proximo).focus();
            }
        }
        function limite_textarea(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont').innerHTML = resto;
            } else {
                document.getElementById('desc_tex_area').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
    <title>Cadastro de Monitor - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <h4>Todos os campos devem ser preenchidos.</h4>
                    <form method="POST" enctype="multipart/form-data" action="cad_mon_.php">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód.:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="cod_m" maxlength="7" required value="M" onkeyup="proximoCampo(this, 'unidade')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade" id="unidade">
                                    <?php
                                        $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>1 ORDER BY id");
                                        $busca_uni->execute();
                                        while (@$linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($unid_master == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="modelo">
                                    <?php
                                        $busca_marc = $pdo_sgt->query("SELECT * FROM tb_marcas ORDER BY marca");
                                        while (@$linha_marc = $busca_marc->fetch(PDO::FETCH_ASSOC)){
                                            $valor_marc = $linha_marc[@id];
                                            $busca_mod = $pdo_sgt->query("SELECT * FROM tb_modelos where marca='".$valor_marc."' AND tipo='2' ORDER BY modelo");
                                            while (@$linha_mod = $busca_mod->fetch(PDO::FETCH_ASSOC)){
                                                $valor_mod = $linha_mod['id']; 
                                                echo "<option value = \"$valor_mod\">$valor_mod - $linha_marc[marca] - $linha_mod[modelo] </option>";
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Série:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nserie" maxlength="255" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Data de Aquisição:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="daquise" maxlength="10" required placeholder="DD/MM/AAAA" onkeyup="proximoCampo(this, 'garantia')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Termino da Garantia:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="garantia" id="garantia" required maxlength="10" placeholder="DD/MM/AAAA" onkeyup="proximoCampo(this, 'loja')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Loja:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="loja" id="loja" maxlength="255" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número da Nota Fiscal:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nnota" maxlength="40" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Valor:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="valor" maxlength="40" placeholder="0,00" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número do Imobilizado:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nptri" maxlength="40" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Descrição do Equipamento: </label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="exampleFormControlTextarea1" name="desc_tex_area" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea(this.value)"></textarea>
                                <label>Caracteres restantes: <span id="cont">500</span></label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Ativo</label>
                            <div class="col-sm-3">
                                <div class="custom-control custom-checkbox">
                                    <input class="custom-control-input" type="checkbox" id="ativo" name="ativo" value="ativo" CHECKED>
                                    <label class="custom-control-label" for="ativo"></label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Arquivo da nota em PDF:</label>
                            <div class="col-sm-3">
                                <label class="custom-file">
                                    <input class="form-control" name="arquivo" id="file" type="file">
                                </label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>