<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function limite_textarea(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont').innerHTML = resto;
            } else {
                document.getElementById('desc_tex_area').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
    <title>Cadastro de Ocorrência de Computadores - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form method="POST" action="cad_oc_comp_.php">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód. do Computador:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="cod_c">
                                    <option value="Cod.">Cod.</option>
                                    <?php
                                        if($unid_master == 1){
                                            $busca = $pdo_sgt->prepare("SELECT * FROM tb_computadores WHERE ativo=:ativo ORDER BY cod_c");
                                            $busca->bindValue(":ativo",'1');
                                        } else {
                                            $busca = $pdo_sgt->prepare("SELECT * FROM tb_computadores WHERE unidade=:unidade AND ativo=:ativo ORDER BY cod_c");
                                            $busca->bindValue(":unidade",$unid_master);
                                            $busca->bindValue(":ativo",'1');
                                        }
                                        $busca->execute();
                                        while ($linha = $busca->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\">$linha[cod_c]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód. do Computador:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo">
                                    <option value="Tipo">Tipo</option>
                                    <option value="1">Alteração</option>
                                    <option value="2">Erro</option>
                                    <option value="3">Movimentação</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Descrição:</label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="exampleFormControlTextarea1" placeholder="Descreva com detalhes a ocorrência!" name="desc_tex_area" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea(this.value)"></textarea>
                                <label>Caracteres restantes: <span id="cont">500</span></label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>