<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

/**
* Sistema de segurança com acesso restrito
*
* Usado para restringir o acesso de certas páginas do seu site
*
*/
//  Configurações do Script
// ==============================
include "conectar.php";
$_SG['conectaServidor'] = true;    // Abre uma conexão com o servidor MySQL?
$_SG['abreSessao'] = true;         // Inicia a sessão com um session_start()?
$_SG['caseSensitive'] = false;     // Usar case-sensitive? Onde 'thiago' é diferente de 'THIAGO'
$_SG['validaSempre'] = true;       // Deseja validar o usuário e a senha a cada carregamento de página?
// ==============================
// ======================================
//   ~ Não edite a partir deste ponto ~
// ======================================
// Verifica se precisa iniciar a sessão
if ($_SG['abreSessao'] == true)
  session_start();
/**
* Função que valida um usuário e senha
*
* @param string $usuario - O usuário a ser validado
* @param string $senha - A senha a ser validada
*
* @return bool - Se o usuário foi validado ou não (true/false)
*/
function validaUsuario($usuario, $senha) {
    global $_SG;
    $cS = ($_SG['caseSensitive']) ? 'BINARY' : '';
    // Usa a função addslashes para escapar as aspas
    $nusuario = addslashes($usuario);
    $nsenha = addslashes($senha);
    // Monta uma consulta SQL (query) para procurar um usuário
    include "conectar.php";
    $busca_user_s = $pdo_sgt->prepare("SELECT id, nome, sobrenome, unidade, unid_temp, temp_0, temp_1, temp_2, temp_3, temp_4, temp_5, temp_6, temp_7, temp_8, temp_9, nivel, avancado, ativo FROM tb_usuarios WHERE ".$cS." usuario=:nusuario AND ".$cS." senha=:nsenha AND ".$cS." ativo = 1 LIMIT 1");
    $busca_user_s->bindValue(":nusuario",$nusuario);
    $busca_user_s->bindValue(":nsenha",$nsenha);
    $busca_user_s->execute();
    $resultado = $busca_user_s->fetch(PDO::FETCH_ASSOC);
  // Verifica se encontrou algum registro
  if (empty($resultado)) {
    // Nenhum registro foi encontrado => o usuário é inválido
    return false;
  } else {
    // Definimos dois valores na sessão com os dados do usuário
    $_SESSION['usuarioID'] = $resultado['id']; // Pega o valor da coluna 'id do registro encontrado no MySQL
    $_SESSION['usuarioNome'] = $resultado['nome']; // Pega o valor da coluna 'nome' do registro encontrado no MySQL
    $_SESSION['usuarioSobrenome'] = $resultado['sobrenome']; // Pega o valor da coluna 'sobrenome' do registro encontrado no MySQL
    $_SESSION['usuarioUnidade'] = $resultado['unidade']; // Pega o valor da coluna 'unidade' do registro encontrado no MySQL
    $_SESSION['usuarioUnid_temp'] = $resultado['unid_temp']; // Pega o valor da coluna 'unidade_temp' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_0'] = $resultado['temp_0']; // Pega o valor da coluna 'temp_0' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_1'] = $resultado['temp_1']; // Pega o valor da coluna 'temp_1' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_2'] = $resultado['temp_2']; // Pega o valor da coluna 'temp_2' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_3'] = $resultado['temp_3']; // Pega o valor da coluna 'temp_3' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_4'] = $resultado['temp_4']; // Pega o valor da coluna 'temp_4' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_5'] = $resultado['temp_5']; // Pega o valor da coluna 'temp_5' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_6'] = $resultado['temp_6']; // Pega o valor da coluna 'temp_6' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_7'] = $resultado['temp_7']; // Pega o valor da coluna 'temp_7' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_8'] = $resultado['temp_8']; // Pega o valor da coluna 'temp_8' do registro encontrado no MySQL
    $_SESSION['usuarioTemp_9'] = $resultado['temp_9']; // Pega o valor da coluna 'temp_9' do registro encontrado no MySQL
    $_SESSION['usuarioNivel'] = $resultado['nivel']; // Pega o valor da coluna 'nivel' do registro encontrado no MySQL
    $_SESSION['usuarioAv'] = $resultado['avancado']; // Pega o valor da coluna 'avancado' do registro encontrado no MySQL
    $_SESSION['usuarioAtivo'] = $resultado['ativo']; // Pega o valor da coluna 'ativo' do registro encontrado no MySQL
    // Verifica a opção se sempre validar o login
    if ($_SG['validaSempre'] == true) {
      // Definimos dois valores na sessão com os dados do login
      $_SESSION['usuarioLogin'] = $usuario;
      $_SESSION['usuarioSenha'] = $senha;
    }
    return true;
  }
}
/**
* Função que protege uma página
*/
$nivel_necessario = 4; // Define o nivel de Geral
function protegePagina() {
  global $_SG;
  if (!isset($_SESSION['usuarioID']) OR !isset($_SESSION['usuarioNome'])) {
    // Não há usuário logado, manda pra página de login
    expulsaVisitante();
  } else if (!isset($_SESSION['usuarioID']) OR !isset($_SESSION['usuarioNome'])) {
    // Há usuário logado, verifica se precisa validar o login novamente
    if ($_SG['validaSempre'] == true) {
      // Verifica se os dados salvos na sessão batem com os dados do banco de dados
      if (!validaUsuario($_SESSION['usuarioLogin'], $_SESSION['usuarioSenha'])) {
        // Os dados não batem, manda pra tela de login
        expulsaVisitante();
      } 
    }
  }
}
// Verifica se não há a variável da sessão que identifica o usuário
if (!isset($_SESSION['usuarioID']) OR ($_SESSION['usuarioNivel'] > $nivel_necessario)) {
  // Redireciona o visitante de volta pro login
  header("Location: ".$sgturl."home.php"); exit;
}
/**
* Função para expulsar um visitante
*/
function expulsaVisitante() {
    include "conectar.php";
    global $_SG;
    // Remove as variáveis da sessão (caso elas existam)
    unset($_SESSION['usuarioID'], $_SESSION['usuarioNome'], $_SESSION['usuarioLogin'], $_SESSION['usuarioSenha'], $_SESSION['usuarioSobrenome'],$_SESSION['usuarioUnidade'],$_SESSION['usuarioUnid_temp'],$_SESSION['usuarioTemp_0'],$_SESSION['usuarioTemp_1'],$_SESSION['usuarioTemp_2'],$_SESSION['usuarioTemp_3'],$_SESSION['usuarioTemp_4'],$_SESSION['usuarioTemp_5'],$_SESSION['usuarioTemp_6'],$_SESSION['usuarioTemp_7'],$_SESSION['usuarioTemp_8'],$_SESSION['usuarioTemp_9'], $_SESSION['usuarioNivel'], $_SESSION['usuarioAv'], $_SESSION['usuarioAtivo']);
    // Manda pra tela de login
    header("Location: ".$sgturl);
}