<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_adm.php");
    protegePagina();
    include "../var_sub.php";
    include "../conectar.php";
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Cadastro de Modelo - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form method="POST" action="cad_mod_.php">
                        <h5>Todos os campos devem ser preenchidos.</h5>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Marca:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="marca">
                                    <?php
                                        $busca = $pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE comp=:comp OR mon=:mon OR eqp=:eqp ORDER BY marca");
                                        $busca->bindValue(":comp",'1');
                                        $busca->bindValue(":mon",'1');
                                        $busca->bindValue(":eqp",'1');
                                        $busca->execute();
                                        while ($linha = $busca->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\">$linha[marca]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control"  name="modelo" required maxlength="80">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo">
                                    <option>Tipo</option>
                                    <option value="1">Computadores</option>
                                    <option value="2">Monitores</option>
                                    <option value="3">Equipamentos</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>