<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include("../seguranca_aux_unid.php");
    protegePagina();
    include "../var_sub.php";
    $pt_c = 1;
?>
<!doctype html>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Cadastro de Switch - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_tb_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col-24 align-self-center">
                    <form action="cad_sw_.php" method="POST">
                        <div class="form-row">
                            <div class="form-group col-md-3">
                                <label>Switch:</label>
                                <select class="form-control custom-select form-control-sm my-1 mr-sm-2" name="sw">
                                    <option>Switch Cód.: </option>
                                    <?php
                                        $busca_eqp=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE tipo=:tipo AND unidade=:unidade ORDER BY cod_e");
                                        $busca_eqp->bindValue(":tipo",7);
                                        $busca_eqp->bindValue(":unidade",$unid_master);
                                        $busca_eqp->execute();
                                        while ($linha_eqp = $busca_eqp->fetch(PDO::FETCH_ASSOC)){
                                            $valor_eqp = $linha_eqp['id']; 
                                            echo "<option value = \"$valor_eqp\">$linha_eqp[cod_e]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="my-1 mr-2">Local:</label>
                                <select class="form-control custom-select form-control-sm my-1 mr-sm-2" name="local">
                                    <option value="a">Selecione um local</option>
                                    <?php
                                        $busca_local=$pdo_sgt->prepare("SELECT * FROM tb_local ORDER BY local");
                                        $busca_local->execute();
                                        while ($linha_local = $busca_local->fetch(PDO::FETCH_ASSOC)){
                                            $valor_local = $linha_local['id'];
                                            $nome_local = $linha_local['local'];
                                            echo "<option value = \"$valor_local\">$nome_local</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="my-1 mr-2">ID Switch:</label>
                                <select class="form-control custom-select form-control-sm my-1 mr-sm-2" name="id_sw">
                                    <option>Sem Seleção</option>
                                    <?php
                                        $sw_c = 1;
                                        while ($sw_c < 21){
                                            echo "<option value = \"$sw_c\">".$sw_c." - Switch</option>";
                                            $sw_c ++;
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-1">
                                <label>Porta</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>Status</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>VLAN</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>Tipo</label>
                            </div>
                            <div class="form-group col-md-2">
                                <label>Descrição</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>Porta</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>Status</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>VLAN</label>
                            </div>
                            <div class="form-group col-md-1">
                                <label>Tipo</label>
                            </div>
                            <div class="form-group col-md-2">
                                <label>Descrição</label>
                            </div>
                        </div>
                        <?php
                            while ($pt_c < 53){
                                echo '<div class="form-row">'
                                    . '<div class="form-group col-md-1">';
                                        if($pt_c <10){
                                            echo '<label>0'.$pt_c.':</label>';
                                        } else {
                                            echo '<label>'.$pt_c.':</label>';
                                        }
                                    echo '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<input class="form-control" type="checkbox" name="status_'.$pt_c.'" CHECKED>'
                                    . '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<select class="custom-select form-control-sm" name="pt_v_'.$pt_c.'">';
                                            $busca_vlan=$pdo_sgt->prepare("SELECT * FROM tb_vlan ORDER BY id_vlan");
                                            $busca_vlan->execute();
                                            while ($linha_vlan = $busca_vlan->fetch(PDO::FETCH_ASSOC)){
                                                $valor_vlan = $linha_vlan['id'];
                                                $nome_vlan = $linha_vlan['vlan'];
                                                echo "<option value = \"$valor_vlan\">$nome_vlan</option>";
                                            }
                                        echo '</select>'
                                    . '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<select class="custom-select form-control-sm" name="pt_t_'.$pt_c.'">'
                                            . '<option value="1">Access</option>'
                                            . '<option value="2">Trunk</option>'
                                            . '<option value="3">Hybrid</option>'
                                        . '</select>'
                                    . '</div>'
                                    . '<div class="form-group col-md-2">'
                                        . '<input class="form-control form-control-sm" maxlength="20" type="text" name="desc_'.$pt_c.'">'
                                    . '</div>';
                                    $pt_c ++;
                                    echo '<div class="form-group col-md-1">';
                                        if($pt_c <10){
                                            echo '<label>0'.$pt_c.':</label>';
                                        } else {
                                            echo '<label>'.$pt_c.':</label>';
                                        }
                                    echo '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<input class="form-control" type="checkbox" name="status_'.$pt_c.'" CHECKED>'
                                    . '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<select class="custom-select form-control-sm" name="pt_v_'.$pt_c.'">';
                                            $busca_vlan=$pdo_sgt->prepare("SELECT * FROM tb_vlan ORDER BY id_vlan");
                                            $busca_vlan->execute();
                                            while ($linha_vlan = $busca_vlan->fetch(PDO::FETCH_ASSOC)){
                                                $valor_vlan = $linha_vlan['id'];
                                                $nome_vlan = $linha_vlan['vlan'];
                                                echo "<option value = \"$valor_vlan\">$nome_vlan</option>";
                                            }
                                        echo '</select>'
                                    . '</div>'
                                    . '<div class="form-group col-md-1">'
                                        . '<select class="custom-select form-control-sm" name="pt_t_'.$pt_c.'">'
                                            . '<option value="1">Access</option>'
                                            . '<option value="2">Trunk</option>'
                                            . '<option value="3">Hybrid</option>'
                                        . '</select>'
                                    . '</div>'
                                    . '<div class="form-group col-md-2">'
                                        . '<input class="form-control form-control-sm" maxlength="20" type="text" name="desc_'.$pt_c.'">'
                                    . '</div>'
                                . '</div>';
                                $pt_c ++;
                            }
                        ?>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>