<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include"../seguranca_aux_unid.php";
    include "../var_sub.php";
    $sw_unid = 0;
    $sw_d = 0;
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Gestão de Switch - SGT</title>
    <script type=”text/javascript”>
        $(function() {
            $(‘ul li a’).bind(‘click’,function(event){
                var $anchor = $(this);
                $(‘html, body’).stop().animate({
                    scrollLeft: $($anchor.attr(‘href’)).offset().left
                }, 1000);
                event.preventDefault();
            });
        })
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="tb_div_unid_comp_f">
                <?php
                    $buscar=$pdo_sgt->prepare("SELECT * FROM tb_switch ORDER BY local,id_sw");
                    $buscar->execute();
                    if($buscar->rowCount() > 0){
                        while($ver = $buscar->fetch(PDO::FETCH_ASSOC)){
                            if($unid_master == 1){
                                $buscar_eqp=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                $buscar_eqp->bindValue(":id",$ver['sw']);
                            } else {
                                $buscar_eqp=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE unidade=:unidade AND id=:id");
                                $buscar_eqp->bindValue(":unidade",$unid_master);
                                $buscar_eqp->bindValue(":id",$ver['sw']);
                            }
                            $buscar_eqp->execute();
                            if($buscar_eqp->rowCount() > 0){
                                while($ver_eqp = $buscar_eqp->fetch(PDO::FETCH_ASSOC)){
                                    $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                                    $busca_unid->bindValue(":id",$ver_eqp['unidade']);
                                    $busca_unid->execute();
                                    $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                                    $busca_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE id=:id");
                                    $busca_mod->bindValue(":id",$ver_eqp['modelo']);
                                    $busca_mod->execute();
                                    $dados_mod=$busca_mod->fetch(PDO::FETCH_ASSOC);
                                    $busca_local=$pdo_sgt->prepare("SELECT * FROM tb_local WHERE id=:id");
                                    $busca_local->bindValue(":id",$ver['local']);
                                    $busca_local->execute();
                                    $dados_local=$busca_local->fetch(PDO::FETCH_ASSOC);
                                    $busca_ip=$pdo_sgt->prepare("SELECT * FROM tb_map_ip WHERE mac=:mac");
                                    $busca_ip->bindValue(":mac",$ver_eqp['mac_1']);
                                    $busca_ip->execute();
                                    $dados_ip=$busca_ip->fetch(PDO::FETCH_ASSOC);
                                    $ativo_sw = explode( '.', $ver['status'] );
                                    $vlan_sw = explode( '.', $ver['vlan'] );
                                    $tipo_sw = explode( '.', $ver['tipo'] );
                                    $desc_sw = explode( '+', $ver['descricao'] );
                                    echo '<div class="form-group mx-sm-1 mb-1">'
                                        . '<label class="col-form-label">Unidade: '.$dados_unid['unidade'].'</label>'
                                        . '<label class="col-form-label mx-sm-2">Switch: '.$dados_mod['modelo'].'</label>'
                                        . '<label class="col-form-label mx-sm-2">Local: '.$dados_local['local'].'</label>';
                                        if($ver_eqp['mac_1'] != "" || $ver_eqp['mac_1'] != null){
                                            echo '<label class="col-form-label mx-sm-2">IP: <a href="http://'.$dados_ip['ip'].'/" target="_blank">'.$dados_ip['ip'].'</a></label>';
                                        }
                                        $lik_sw="'alt_sw.php?id=".$ver['id']."'"; 
                                        echo '<button type="button" class="btn btn-primary btn-sm" title="Editar" onclick="javascript: window.location.href='.$lik_sw.'">Editar</button>'
                                    . '</div>'
                                    . '<table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">'
                                        . '<thead>'
                                            . '<tr align="center" bgcolor=#B8DAFF>'
                                                . '<th scope="col" colspan="27" id="id'.$ver['id'].'">'
                                                    . '<div class="mx-sm-1">'
                                                        . 'Switch - '.$ver['id_sw']
                                                    . '</div>'
                                                .'</th>'
                                            . '</tr>'
                                        . '</thead>'
                                        . '<tbody>';
                                            $pt_sw = 1;
                                            $sw_ativo = 0;
                                            $sw_vlan = 0;
                                            $sw_tipo = 0;
                                            $sw_desc = 0;
                                            $sw_canal_1 = 1;
                                            $sw_canal_2 = 1;
                                            $sw_canal_3 = 1;
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Porta'
                                                    . '</div>'
                                                . '</td>';
                                                while ($pt_sw < 52){
                                                    if($ativo_sw[$sw_ativo] == 1){
                                                        $titulo = "Status: Ativo\n";
                                                    } else {
                                                        $titulo = "Status: Desativado\n";
                                                    }
                                                    $busca_vlan=$pdo_sgt->prepare("SELECT * FROM tb_vlan WHERE id=:id");
                                                    $busca_vlan->bindValue(":id",$vlan_sw[$sw_vlan]);
                                                    $busca_vlan->execute();
                                                    $dados_vlan=$busca_vlan->fetch(PDO::FETCH_ASSOC);
                                                    $titulo .= "VLAN: ".$dados_vlan['id_vlan'].'-'.$dados_vlan['vlan']."\n";
                                                    switch($tipo_sw[$sw_tipo]) {
                                                        case 1 : $titulo .= "Tipo: Access\n"; break;
                                                        case 2 : $titulo .= "Tipo: Trunk\n"; break;
                                                        default: $titulo .= "Tipo: Hybrid\n";
                                                    }
                                                    $busca_eqp_2=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_2->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_2->execute();
                                                    $dados_eqp_2=$busca_eqp_2->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_2=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_2->bindValue(":unidade",$dados_eqp_2['unidade']);
                                                    $busca_canal_2->bindValue(":local",$ver['local']);
                                                    $busca_canal_2->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_2->bindValue(":sw_pt",$sw_canal_2);
                                                    $busca_canal_2->execute();
                                                    $dados_canal_2=$busca_canal_2->fetch(PDO::FETCH_ASSOC);
                                                    $comp_canal = $dados_canal_2['pc_s'] + $dados_canal_2['link'] + $dados_canal_2['pc_d'];
                                                    $titulo .= "Comp. do Canal: ".$comp_canal."\n";
                                                    if($pt_sw < 49){
                                                        echo'<td class="align-middle" bgcolor=#5BC0DE title="'.$titulo.'">'
                                                            . '<div class="mx-sm-1">'
                                                                .$pt_sw
                                                            . '</div>'
                                                        . '</td>';
                                                    } else {
                                                        echo'<td class="align-middle" bgcolor=#FC9999 title="'.$titulo.'">'
                                                            . '<div class="mx-sm-1">'
                                                                .$pt_sw
                                                            . '</div>'
                                                        . '</td>';
                                                    } 
                                                    $pt_sw=$pt_sw+2;
                                                    $sw_ativo=$sw_ativo+2;
                                                    $sw_vlan=$sw_vlan+2;
                                                    $sw_tipo=$sw_tipo+2;
                                                    $sw_canal_2=$sw_canal_2+2;
                                                }
                                            echo '</tr>';
                                            $sw_desc = 0;
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Desc. da Porta'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_desc < 52){
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">'
                                                            .'<p><small>'.$desc_sw[$sw_desc].'</small></p>'
                                                        . '</div>'
                                                    . '</td>'; 
                                                    $sw_desc=$sw_desc+2;
                                                }
                                            echo '</tr>';
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Canal'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_canal_1 < 52){
                                                    $busca_eqp_1=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_1->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_1->execute();
                                                    $dados_eqp_1=$busca_eqp_1->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_1=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_1->bindValue(":unidade",$dados_eqp_1['unidade']);
                                                    $busca_canal_1->bindValue(":local",$ver['local']);
                                                    $busca_canal_1->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_1->bindValue(":sw_pt",$sw_canal_1);
                                                    $busca_canal_1->execute();
                                                    $dados_canal_1=$busca_canal_1->fetch(PDO::FETCH_ASSOC);
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">';
                                                            if($dados_canal_1['pp'] != "" || $dados_canal_1['pp'] != null){
                                                                echo '<p><small>'.$dados_canal_1['pp'].'/'.$dados_canal_1['pp_pt'].'</small></p>';
                                                            }
                                                        echo '</div>'
                                                    . '</td>'; 
                                                    $sw_canal_1=$sw_canal_1+2;
                                                }
                                            echo '</tr>';
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Desc. do Canal'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_canal_3 < 52){
                                                    $busca_eqp_3=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_3->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_3->execute();
                                                    $dados_eqp_3=$busca_eqp_3->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_3=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_3->bindValue(":unidade",$dados_eqp_3['unidade']);
                                                    $busca_canal_3->bindValue(":local",$ver['local']);
                                                    $busca_canal_3->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_3->bindValue(":sw_pt",$sw_canal_3);
                                                    $busca_canal_3->execute();
                                                    $dados_canal_3=$busca_canal_3->fetch(PDO::FETCH_ASSOC);
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">'
                                                            .'<p><small>'.$dados_canal_3['descricao'].'</small></p>'
                                                        . '</div>'
                                                    . '</td>'; 
                                                    $sw_canal_3=$sw_canal_3+2;
                                                }
                                            echo '</tr>';
                                            
                                            $pt_sw = 2;
                                            $sw_ativo = 1;
                                            $sw_vlan = 1;
                                            $sw_tipo = 1;
                                            $sw_desc = 1;
                                            $sw_canal_1 = 2;
                                            $sw_canal_2 = 2;
                                            $sw_canal_3 = 2;
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Porta'
                                                    . '</div>'
                                                . '</td>';
                                                while ($pt_sw < 53){
                                                    if($ativo_sw[$sw_ativo] == 1){
                                                        $titulo = "Status: Ativo\n";
                                                    } else {
                                                        $titulo = "Status: Desativado\n";
                                                    }
                                                    $busca_vlan=$pdo_sgt->prepare("SELECT * FROM tb_vlan WHERE id=:id");
                                                    $busca_vlan->bindValue(":id",$vlan_sw[$sw_vlan]);
                                                    $busca_vlan->execute();
                                                    $dados_vlan=$busca_vlan->fetch(PDO::FETCH_ASSOC);
                                                    $titulo .= "VLAN: ".$dados_vlan['id_vlan'].'-'.$dados_vlan['vlan']."\n";
                                                    switch($tipo_sw[$sw_tipo]) {
                                                        case 1 : $titulo .= "Tipo: Access\n"; break;
                                                        case 2 : $titulo .= "Tipo: Trunk\n"; break;
                                                        default: $titulo .= "Tipo: Hybrid\n";
                                                    }
                                                    $busca_eqp_2=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_2->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_2->execute();
                                                    $dados_eqp_2=$busca_eqp_2->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_2=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_2->bindValue(":unidade",$dados_eqp_2['unidade']);
                                                    $busca_canal_2->bindValue(":local",$ver['local']);
                                                    $busca_canal_2->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_2->bindValue(":sw_pt",$sw_canal_2);
                                                    $busca_canal_2->execute();
                                                    $dados_canal_2=$busca_canal_2->fetch(PDO::FETCH_ASSOC);
                                                    $comp_canal = $dados_canal_2['pc_s'] + $dados_canal_2['link'] + $dados_canal_2['pc_d'];
                                                    $titulo .= "Comp. do Canal: ".$comp_canal."\n";
                                                    if($pt_sw < 49){
                                                        echo'<td class="align-middle" bgcolor=#5BC0DE title="'.$titulo.'">'
                                                            . '<div class="mx-sm-1">'
                                                                .$pt_sw
                                                            . '</div>'
                                                        . '</td>';
                                                    } else {
                                                        echo'<td class="align-middle" bgcolor=#FC9999 title="'.$titulo.'">'
                                                            . '<div class="mx-sm-1">'
                                                                .$pt_sw
                                                            . '</div>'
                                                        . '</td>';
                                                    } 
                                                    $pt_sw=$pt_sw+2;
                                                    $sw_ativo=$sw_ativo+2;
                                                    $sw_vlan=$sw_vlan+2;
                                                    $sw_tipo=$sw_tipo+2;
                                                    $sw_canal_2=$sw_canal_2+2;
                                                }
                                            echo '</tr>';
                                            $sw_desc = 1;
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Desc. da Porta'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_desc < 52){
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">'
                                                            .'<p><small>'.$desc_sw[$sw_desc].'</small></p>'
                                                        . '</div>'
                                                    . '</td>'; 
                                                    $sw_desc=$sw_desc+2;
                                                }
                                            echo '</tr>';
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Canal'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_canal_1 < 53){
                                                    $busca_eqp_1=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_1->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_1->execute();
                                                    $dados_eqp_1=$busca_eqp_1->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_1=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_1->bindValue(":unidade",$dados_eqp_1['unidade']);
                                                    $busca_canal_1->bindValue(":local",$ver['local']);
                                                    $busca_canal_1->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_1->bindValue(":sw_pt",$sw_canal_1);
                                                    $busca_canal_1->execute();
                                                    $dados_canal_1=$busca_canal_1->fetch(PDO::FETCH_ASSOC);
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">';
                                                            if($dados_canal_1['pp'] != "" || $dados_canal_1['pp'] != null){
                                                                echo '<p><small>'.$dados_canal_1['pp'].'/'.$dados_canal_1['pp_pt'].'</small></p>';
                                                            }
                                                        echo '</div>'
                                                    . '</td>'; 
                                                    $sw_canal_1=$sw_canal_1+2;
                                                }
                                            echo '</tr>';
                                            echo '<tr align="center">'
                                                . '<td class="align-middle" scope="row" bgcolor=#5BC0DE>'
                                                    . '<div class="mx-sm-1">'
                                                        .'Desc. do Canal'
                                                    . '</div>'
                                                . '</td>';
                                                while ($sw_canal_3 < 53){
                                                    $busca_eqp_3=$pdo_sgt->prepare("SELECT * FROM tb_equipamentos WHERE id=:id");
                                                    $busca_eqp_3->bindValue(":id",$ver['sw']);
                                                    $busca_eqp_3->execute();
                                                    $dados_eqp_3=$busca_eqp_3->fetch(PDO::FETCH_ASSOC);
                                                    $busca_canal_3=$pdo_sgt->prepare("SELECT * FROM tb_map_canal WHERE unidade=:unidade AND local=:local  AND sw=:sw  AND sw_pt=:sw_pt");
                                                    $busca_canal_3->bindValue(":unidade",$dados_eqp_3['unidade']);
                                                    $busca_canal_3->bindValue(":local",$ver['local']);
                                                    $busca_canal_3->bindValue(":sw",$ver['id_sw']);
                                                    $busca_canal_3->bindValue(":sw_pt",$sw_canal_3);
                                                    $busca_canal_3->execute();
                                                    $dados_canal_3=$busca_canal_3->fetch(PDO::FETCH_ASSOC);
                                                    echo'<td class="align-middle">'
                                                        . '<div class="mx-sm-1">'
                                                            .'<p><small>'.$dados_canal_3['descricao'].'</small></p>'
                                                        . '</div>'
                                                    . '</td>'; 
                                                    $sw_canal_3=$sw_canal_3+2;
                                                }
                                            echo '</tr>';
                                        echo'</tbody>';
                                    echo'<tfoot></table></table>';
                                }
                            }
                        }
                    }else{
                        echo'Sem dados cadastrais<br>';
                    }
                ?>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>