<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "unid_alt_comp_.php";
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function proximoCampo(atual,proximo){
            if(atual.value.length >= atual.maxLength){
                document.getElementById(proximo).focus();
            }
        }
        function limite_textarea(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont').innerHTML = resto;
            } else {
                document.getElementById('desc_tex_area').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
<title>Alteração de Computador - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form enctype="multipart/form-data" action="unid_alt_comp_.php" method="POST">
                        <?php
                            $id = $dados['id'];
                            $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                            $busca_unid->bindValue(":id",$dados['unidade']);
                            $busca_unid->execute();
                            $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                            $busca_tipo=$pdo_sgt->prepare("SELECT * FROM tb_tipos WHERE id=:id");
                            $busca_tipo->bindValue(":id",$dados['tipo']);
                            $busca_tipo->execute();
                            $dados_tipo=$busca_tipo->fetch(PDO::FETCH_ASSOC);
                            $busca_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE id=:id");
                            $busca_mod->bindValue(":id",$dados['modelo']);
                            $busca_mod->execute();
                            $dados_mod=$busca_mod->fetch(PDO::FETCH_ASSOC);
                            $busca_marc=$pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE id=:id");
                            $busca_marc->bindValue(":id",$dados_mod['marca']);
                            $busca_marc->execute();
                            $dados_marc=$busca_marc->fetch(PDO::FETCH_ASSOC);  
                            $busca_proc=$pdo_sgt->prepare("SELECT * FROM tb_proc WHERE id=:id");
                            $busca_proc->bindValue(":id",$dados['proc']);
                            $busca_proc->execute();
                            $dados_proc=$busca_proc->fetch(PDO::FETCH_ASSOC);
                            $busca_clok=$pdo_sgt->prepare("SELECT * FROM tb_ram_clok WHERE id=:id");
                            $busca_clok->bindValue(":id",$dados['ram_clok']);
                            $busca_clok->execute();
                            $dados_clok=$busca_clok->fetch(PDO::FETCH_ASSOC);
                            $busca_tipo_hd=$pdo_sgt->prepare("SELECT * FROM tb_tipo_hd WHERE id=:id");
                            $busca_tipo_hd->bindValue(":id",$dados['tipo_hd']);
                            $busca_tipo_hd->execute();
                            $dados_tipo_hd=$busca_tipo_hd->fetch(PDO::FETCH_ASSOC);
                        ?>
                        <input style="display: none" type="text" readonly name="id" value="<?php echo$dados['id']; ?>" />
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód.:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados['cod_c']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <?php
                                    if ($nivel < 3 or $nivel == 5) {
                                        echo '<select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">';
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>1 ORDER BY id");
                                            $busca_uni->execute();
                                            while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                                $valor = $linha['id']; 
                                                echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo ' selected';} echo ">$linha[unidade]</option>";
                                            }
                                        echo '</select>';
                                    } else {
                                        echo '<input type="text" readonly class="form-control-plaintext" value="'; echo $dados_unid['unidade']; echo '">'
                                        . '<input type="text" style="display: none" class="form-control-plaintext" name="unidade" value="'; echo $dados['unidade']; echo '">';
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados_tipo['tipo']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número do lacre:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nlacre" maxlength="20" value="<?php echo$dados['nlacre']; ?>" onkeyup="proximoCampo(this, 'setor')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Setor:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="setor" id="setor">
                                    <option value="a" >Sem Seleção</option>
                                    <?php
                                        $busca_set = $pdo_sgt->query("SELECT * FROM tb_setores ORDER BY setor");
                                        while ($linha = $busca_set->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['setor'] == $valor){echo ' selected';} echo ">$valor - $linha[setor]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Net BIOS:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="netbios" required maxlength="40" value="<?php echo$dados['netbios']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Endereço MAC Cabo:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="mac_c" maxlength="17" size="17" value="<?php echo$dados['mac_c']; ?>" onkeyup="proximoCampo(this, 'mac_w')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Endereço MAC Wi-Fi:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="mac_w" id="mac_w" maxlength="17" size="17" value="<?php echo$dados['mac_w']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Marca:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados_marc['marca']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados_mod['modelo']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Série:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" size="30" value="<?php echo$dados['nserie']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Data de Aquisição:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['daquise'])); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Termino da Garantia:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['garantia'])); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Placa Mãe:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados['pmae']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Processador:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" size="30" value="<?php echo $dados_proc['des_proc']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Processadores:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['nproc']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Memória RAM:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="ram" maxlength="80" value="<?php echo$dados['ram']; ?> GB">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Clok RAM:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="ram_clok">
                                    <option value = "a">Sem Seleção</option>
                                    <?php
                                        $busca_clok=$pdo_sgt->query("SELECT * FROM tb_ram_clok ORDER BY clok");
                                        while ($linha = $busca_clok->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['ram_clok'] == $valor){echo ' selected';} echo ">$valor - $linha[clok] MHz</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">HD:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="hd" maxlength="80" value="<?php echo$dados['hd']; ?> GB">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Tipo do HD:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="tipo_hd">
                                    <option>Tipo do HD</option>
                                    <?php
                                        $busca_tipo_hd=$pdo_sgt->query("SELECT * FROM tb_tipo_hd ORDER BY tipo");
                                        while ($linha = $busca_tipo_hd->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['tipo_hd'] == $valor){echo ' selected';} echo ">$valor - $linha[tipo]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Descrição HD:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="desc_hd" maxlength="255" value="<?php echo$dados['desc_hd']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Placa de Vídeo:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="plc_video">
                                    <option>Placa de Vídeo</option>
                                    <?php
                                        $busca_videos=$pdo_sgt->query("SELECT * FROM tb_videos ORDER BY des_vid");
                                        while ($linha = $busca_videos->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['plc_video'] == $valor){echo ' selected';} echo ">$valor - $linha[des_vid]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Placas de Vídeo:</label>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" name="nplc_video" maxlength="80" value="<?php echo$dados['nplc_video']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Sistema:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="sistema">
                                    <option>Sistema</option>
                                    <?php
                                        $busca_sis=$pdo_sgt->query("SELECT * FROM tb_sistemas ORDER BY sistema");
                                        while ($linha = $busca_sis->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['sistema'] == $valor){echo ' selected';} echo ">$valor - $linha[sistema]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Office:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="office">
                                    <option>Office</option>
                                    <?php
                                        $busca_off=$pdo_sgt->query("SELECT * FROM tb_offices ORDER BY office");
                                        while ($linha = $busca_off->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha['id']; 
                                            echo "<option value = \"$valor\""; if($dados['office'] == $valor){echo ' selected';} echo ">$valor - $linha[office]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Monitor 1:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="cod_mon1">
                                    <option>Monitor 1</option>
                                    <?php
                                        $busca_mon1_marc=$pdo_sgt->query("SELECT * FROM tb_marcas WHERE mon='1' ORDER BY marca");
                                        while ($dados_mon1_marc=$busca_mon1_marc->fetch(PDO::FETCH_ASSOC)){
                                            $busca_mon1_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE marca=:marca AND tipo='2' ORDER BY modelo");
                                            $busca_mon1_mod->bindValue(":marca",$dados_mon1_marc['id']);
                                            $busca_mon1_mod->execute();
                                            while ($dados_mon1_mod=$busca_mon1_mod->fetch(PDO::FETCH_ASSOC)){
                                                $busca_mon1=$pdo_sgt->prepare("SELECT * FROM tb_monitores WHERE unidade=:unidade AND modelo=:modelo ORDER BY cod_m");
                                                $busca_mon1->bindValue(":unidade",$dados['unidade']);
                                                $busca_mon1->bindValue(":modelo",$dados_mon1_mod['id']);
                                                $busca_mon1->execute();
                                                while ($dados_mon1_=$busca_mon1->fetch(PDO::FETCH_ASSOC)){
                                                    $valor_mon1_ = $dados_mon1_['id'];
                                                    echo "<option value = \"$valor_mon1_\""; if($dados['cod_mon1'] == $valor_mon1_){echo ' selected';} echo ">$dados_mon1_[cod_m] - $dados_mon1_marc[marca] - $dados_mon1_mod[modelo]</option>";
                                                }
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Monitor 2:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="cod_mon2">
                                    <option>Monitor 2</option>
                                    <?php
                                        $busca_mon2_marc=$pdo_sgt->query("SELECT * FROM tb_marcas WHERE mon='1' ORDER BY marca");
                                        while ($dados_mon2_marc=$busca_mon2_marc->fetch(PDO::FETCH_ASSOC)){
                                            $busca_mon2_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE marca=:marca AND tipo='2' ORDER BY modelo");
                                            $busca_mon2_mod->bindValue(":marca",$dados_mon2_marc['id']);
                                            $busca_mon2_mod->execute();
                                            while ($dados_mon2_mod=$busca_mon2_mod->fetch(PDO::FETCH_ASSOC)){
                                                $busca_mon2=$pdo_sgt->prepare("SELECT * FROM tb_monitores WHERE unidade=:unidade AND modelo=:modelo ORDER BY cod_m");
                                                $busca_mon2->bindValue(":unidade",$dados['unidade']);
                                                $busca_mon2->bindValue(":modelo",$dados_mon2_mod['id']);
                                                $busca_mon2->execute();
                                                while ($dados_mon2_=$busca_mon2->fetch(PDO::FETCH_ASSOC)){
                                                    $valor_mon2_ = $dados_mon2_['id'];
                                                    echo "<option value = \"$valor_mon2_\""; if($dados['cod_mon2'] == $valor_mon2_){echo ' selected';} echo ">$dados_mon2_[cod_m] - $dados_mon2_marc[marca] - $dados_mon2_mod[modelo]</option>";
                                                }
                                            }
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Descrição do Computador: </label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="exampleFormControlTextarea1" name="desc_tex_area" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea(this.value)"><?php echo $dados['desc_comp']; ?></textarea>
                                <label>Caracteres restantes: <span id="cont">500</span></label>
                            </div>
                        </div>
                        <?php
                            if ($nivel == 1 or $nivel == 2 or $nivel == 5) {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Número do Imobilizado:</label>'
                                    . '<div class="col-sm-3">'
                                        . '<input type="text" class="form-control" name="nptri" maxlength="40" value="'.$dados['nptri'].'">'
                                    . '</div>'
                                . '</div>';
                            } else {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Número do Imobilizado:</label>'
                                    . '<div class="col-sm-3">'
                                        . '<input type="text" readonly class="form-control-plaintext" value="'.$dados['nptri'].'">'
                                    . '</div>'
                                . '</div>'
                                . '<input style="display: none" type="text" readonly name="nptri" id="nptri" maxlength="40" size="30" value="'; echo $dados['nptri']; echo '"/><br>';
                            }
                        ?>
                        <?php
                            if ($nivel == 1) {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Ativo</label>'
                                    . '<div class="col-sm-3">'
                                        . '<div class="custom-control custom-checkbox">'
                                            . '<input class="custom-control-input" type="checkbox" id="ativo" name="ativo" value="ativo"'; if($dados['ativo'] != 0){echo ' CHECKED';} echo '>'
                                            . '<label class="custom-control-label" for="ativo"></label>'
                                        . '</div>'
                                    . '</div>'
                                . '</div>';
                            } else {
                                echo  '<input style="display: none" type="text" name="ativo" '; if($dados['ativo'] != 0){echo ' CHECKED';}; echo '>';
                            }
                        ?>
                        <button type="submit" class="btn btn-primary">Alterar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="container-fluid content_tb_sgt">
            <div class="table-responsive-sm tab_sgt content_tb_sgt">
                <div class="form-group row"></div>
                <table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">
                    <thead>
                        <tr class="table-primary">
                            <th scope="col">Data</th>
                            <th scope="col">Usuário</th>
                            <th scope="col">Tipo</th>
                            <th scope="col">Descrição</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $busca_hist=$pdo_sgt->prepare("SELECT * FROM tb_oc_comp WHERE cod_c=:id");
                        $busca_hist->bindValue(":id",$id);
                        $busca_hist->execute();
                        if($busca_hist->rowCount() > 0){
                            while($ver = $busca_hist->fetch(PDO::FETCH_ASSOC)){
                                switch($ver['tipo']) {
                                    case 1 : $tipo="Alteração";
                                        break;
                                    case 2 : $tipo="Erro";
                                        break;
                                    case 3 : $tipo="Movimentação";
                                        break;
                                    default: $tipo="Cadastro";
                                }
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Data">'.date('d/m/Y H:i:s', strtotime($ver['dt'])).'</td>'
                                    . '<td class="align-middle" title="Usuário">'.$ver['user_nome'].'</td>'
                                    . '<td class="align-middle" title="Tipo">'.$tipo.'</td>'
                                    . '<td class="align-middle" title="Descrição">'.$ver['des'].'</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais';
                        }
                    ?>
                    </tbody>
                    <tfoot></tfoot>
                </table>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>