<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "unid_alt_mon_.php";
    include "../var_sub.php";
?>
<!DOCTYPE HTML>
<html>
<head>
    <?php
        include '../css.html';
    ?>
    <script type="text/javascript">
        function limite_textarea(valor) {
            quant = 500;
            total = valor.length;
            if(total <= quant) {
                resto = quant - total;
                document.getElementById('cont').innerHTML = resto;
            } else {
                document.getElementById('desc_tex_area').value = valor.substr(0,quant);
            }
        }
    </script>
    <meta charset="UTF-8">
    <title>Alteração de Monitor - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid content_sgt">
            <div class="row">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form name="id" id="id" enctype="multipart/form-data" action="unid_alt_mon_.php" method="POST">
                        <?php
                            $id = $dados['id'];
                            $busca_unid=$pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                            $busca_unid->bindValue(":id",$dados['unidade']);
                            $busca_unid->execute();
                            $dados_unid=$busca_unid->fetch(PDO::FETCH_ASSOC);
                            $busca_mod=$pdo_sgt->prepare("SELECT * FROM tb_modelos WHERE id=:id");
                            $busca_mod->bindValue(":id",$dados['modelo']);
                            $busca_mod->execute();
                            $dados_mod=$busca_mod->fetch(PDO::FETCH_ASSOC);
                            $busca_marc=$pdo_sgt->prepare("SELECT * FROM tb_marcas WHERE id=:id");
                            $busca_marc->bindValue(":id",$dados_mod['marca']);
                            $busca_marc->execute();
                            $dados_marc=$busca_marc->fetch(PDO::FETCH_ASSOC);
                        ?>
                        <input style="display: none" type="text" readonly=\"readonly\" name="id" value="<?php echo$dados['id']; ?>">
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Cód.:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados['cod_m']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <?php
                                    if ($nivel < 3 or $nivel == 5) {
                                        echo '<select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="unidade">';
                                            include "conectar.php";
                                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id>1 ORDER BY id");
                                            $busca_uni->execute();
                                            while ($linha = $busca_uni->fetch(PDO::FETCH_ASSOC)){
                                                $valor = $linha['id']; 
                                                echo "<option value = \"$valor\""; if($dados['unidade'] == $valor){echo 'selected';} echo ">$linha[unidade]</option>";
                                            }
                                        echo '</select>';
                                    } else {
                                        echo '<input type="text" readonly class="form-control-plaintext" value="'; echo $dados_unid['unidade']; echo '">'
                                        . '<input type="text" style="display: none" class="form-control-plaintext" name="unidade" value="'; echo $dados['unidade']; echo '">';
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Setor:</label>
                            <div class="col-sm-3">
                                <select class="custom-select mb-2 mr-sm-2 mb-sm-0 form-control" name="setor">
                                    <option value = \"a\">Sem Seleção</option>
                                    <?php
                                        $busca_set = $pdo_sgt->query("SELECT * FROM tb_setores ORDER BY setor");
                                        while (@$linha = $busca_set->fetch(PDO::FETCH_ASSOC)){
                                            $valor = $linha[@id]; 
                                            echo "<option value = \"$valor\""; if($dados['setor'] == $valor){echo ' selected';} echo ">$valor - $linha[setor]</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Marca:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados_marc['marca']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Modelo:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo$dados_mod['modelo']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Número de Série:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" size="30" value="<?php echo$dados['nserie']; ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Data de Aquisição:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['daquise'])); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Termino da Garantia:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo date('d/m/Y', strtotime($dados['garantia'])); ?>">
                            </div>
                        </div>
                        <?php
                            if ($nivel == 1 or $nivel == 2 or $nivel == 5) {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Número do Imobilizado:</label>'
                                    . '<div class="col-sm-3">'
                                        . '<input type="text" class="form-control" name="nptri" maxlength="40" value="'.$dados['nptri'].'">'
                                    . '</div>'
                                . '</div>';
                            } else {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Número do Imobilizado:</label>'
                                    . '<div class="col-sm-3">'
                                        . '<input type="text" readonly class="form-control-plaintext" value="'.$dados['nptri'].'">'
                                    . '</div>'
                                . '</div>'
                                . '<input style="display: none" type="text" readonly name="nptri" id="nptri" maxlength="40" size="30" value="'; echo$dados['nptri']; echo'"/><br>';
                            }
                        ?>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" >Descrição do Monitor: </label>
                            <div class="col-sm-3">
                                <textarea class="form-control" id="exampleFormControlTextarea1" name="desc_tex_area" maxlength="500" rows="8" cols="33" onkeyup="limite_textarea(this.value)"><?php echo$dados['desc_mon']; ?></textarea>
                                <label>Caracteres restantes: <span id="cont">500</span></label>
                            </div>
                        </div>
                        <?php
                            if ($nivel == 1) {
                                echo '<div class="form-group row">'
                                    . '<label class="col-sm-2 col-form-label">Ativo</label>'
                                    . '<div class="col-sm-3">'
                                        . '<div class="custom-control custom-checkbox">'
                                            . '<input class="custom-control-input" type="checkbox" id="ativo" name="ativo" value="ativo"'; if($dados['ativo'] != 0){echo 'CHECKED';} echo '>'
                                            . '<label class="custom-control-label" for="ativo"></label>'
                                        . '</div>'
                                    . '</div>'
                                . '</div>';
                            } else {
                                echo  '<input style="display: none" type="text" name="ativo" '; if($dados['ativo'] != 0){echo ' CHECKED';}; echo '>';
                            }
                        ?>
                        <input type="submit" class="btn btn-primary" value="Alterar"/>
                        <input type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;" value="Cancelar"/>
                    </form>
                    <?php
                        echo'<table class="table-responsive-xl table-striped table-hover table-condensed table-bordered">'
                        . '<thead>'
                            . '<tr class="table-primary">'
                                . '<th scope="col">Data</th>'
                                . '<th scope="col">Usuário</th>'
                                . '<th scope="col">Tipo</th>'
                                . '<th scope="col">Descrição</th>'
                            . '</tr>'
                        . '</thead>'
                        . '<tbody>';
                        $busca_hist=$pdo_sgt->prepare("SELECT * FROM tb_oc_mon WHERE cod_m=:id");
                        $busca_hist->bindValue(":id",$id);
                        $busca_hist->execute();
                        if($busca_hist->rowCount() > 0){
                            while($ver = $busca_hist->fetch(PDO::FETCH_ASSOC)){
                                if($ver['tipo']==1){$tipo="Alteração";}else{if($ver['tipo']==2){$tipo="Erro";}else{$tipo="Movimentação";}}
                                echo'<tr align="center">'
                                    . '<td class="align-middle" scope="row" title="Data">'.date('d/m/Y H:i:s', strtotime($ver['dt'])).'</td>'
                                    . '<td class="align-middle" title="Usuário">'.$ver['user_nome'].'</td>'
                                    . '<td class="align-middle" title="Tipo">'.$tipo.'</td>'
                                    . '<td class="align-middle" title="Descrição">'.$ver['des'].'</td>'
                                . '</tr>';
                            }
                        }else{
                            echo'Sem dados cadastrais<br>';
                        }
                        echo'</tbody>'
                        . '<tfoot></table>'
                    . '</table>'
                    ?>
                </div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>