<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "busca_user_.php";
    include "../var_sub.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Apagar Usuário - SGT</title>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="row content_tb_sgt">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <h4>ATENÇÃO, OS DADOS SERÃO APAGADOS!!!</h4>
                    <form name="id" id="id" action="del_user_.php" method="POST">
                        <?php
                            $unid_b_ = $dados['unidade'];
                            $nivel_b_ = $dados['nivel'];
                            $ativo_b_ = $dados['ativo'];
                            $busca_uni = $pdo_sgt->prepare("SELECT * FROM tb_unidades WHERE id=:id");
                            $busca_uni->bindValue(":id",$dados['unidade']);
                            $busca_uni->execute();
                            $dados_ = $busca_uni->fetch(PDO::FETCH_ASSOC);
                            switch($nivel_b_) {
                                case 1 : $nivel_="Máster"; break;
                                case 2 : $nivel_="Administrador"; break;
                                case 3 : $nivel_="Gerente Unidade"; break;
                                case 4 : $nivel_="Auxiliar Unidade"; break;
                                case 5 : $nivel_="Colaborador Geral"; break;
                                default: $nivel_="Consultor Unidade";
                            }
                            if($ativo_b_==1){
                                $ativo_="Ativo";
                            }else{
                                $ativo_="Desativado";
                            }
                        ?>
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>" /><br />
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Usuário:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['usuario']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nome:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['nome']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Sobrenome:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['sobrenome']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">e-Mail:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['email']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Unidade:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados_['unidade']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nível:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $nivel_; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Ativo:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $ativo_; ?>"/>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-danger">Apagar</button>
                        <button type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;">Cancelar</button>
                    </form>
                </div>
                <div class="col-24 col-md-1"></div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>