<?php
#   SGT - The SGT for Internet - http://sgt.eti.br
#   Copyright (c) 2016-2018, Jean Azevedo. All rights reserved.

#   This file is part of SGT.

#   SGT is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   any later version.

#   SGT is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

    include "../conectar.php";
    include "meu_user_.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php
        include '../css.html';
    ?>
    <meta charset="UTF-8">
    <title>Meu Usuário - SGT</title>
    <script>
        function verifica_forca(senha){
            forca = 0;
            mostra = document.getElementById("mostra");
            if((senha.length > 7) && (senha.length <= 12)){
                forca += 10;
            }else if((senha.length>12)){
                forca += 25;
            }
            if(senha.match(/[a-z]+/)){
                forca += 10;
            }
            if(senha.match(/[A-Z]+/)){
                forca += 20;
            }
            if(senha.match(/\d+/)){
                forca += 20;
            }
            if(senha.match(/\W+/)){
                forca += 25;
            }
            return mostra_res();
            return libera_aplicar();
        }
        function mostra_res(){
            if(forca <=30){
                mostra.innerHTML = '<label style="color:#FF0000;"> Fraca </label>';
            }else if((forca > 30) && (forca < 60)){
                mostra.innerHTML = '<label style="color:#FFBE00;"> Boa </label>'; 
            }else if((forca >= 60) && (forca < 85)){
                mostra.innerHTML = '<label style="color:#0000FF;"> Forte </label>';
            }else {
                mostra.innerHTML = '<label style="color:#00CD00;"> Excelente </label>';
            }
        }
        function verifica_iguais(){
            senha1=document.getElementById("senha");
            senha2=document.getElementById("csenha");

            iguais=document.getElementById("iguais");
            if(senha1.value==senha2.value){
                iguais.innerHTML = '<label style="color:#00CD00;"> Senhas digitadas são iguais. </label>';
            }else{
                iguais.innerHTML = '<label style="color:#FF0000;"> Senhas digitadas não são iguais. </label>';
            }
            return libera_aplicar();
        }
    </script>
</head>
<body>
    <div class="main_sgt">
        <?php
            include '../menu.html';
        ?>
        <div class="container-fluid">
            <div class="row content_tb_sgt">
                <div class="col-24 col-md-1"></div>
                <div class="col align-self-center">
                    <form action="meu_user_.php" method="POST" onsubmit="return true">
                        <input style="display: none" type="text" readonly name="id" value="<?php echo $dados['id']; ?>" />
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Usuário:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['usuario']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Nome:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['nome']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Sobrenome:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['sobrenome']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">e-Mail:</label>
                            <div class="col-sm-3">
                                <input type="text" readonly class="form-control-plaintext" value="<?php echo $dados['email']; ?>"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Senha:</label>
                            <div class="col-sm-3">
                                <input type="password" class="form-control" placeholder="Senha" name="senha" id="senha" required onkeyup="javascript:verifica_forca(this.value)"/>
                            </div> 
                            <label id="mostra"></label>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Confirmar Senha:</label>
                            <div class="col-sm-3">
                                <input type="password" class="form-control" placeholder="Confirma Senha" name="csenha" id="csenha" required onkeyup="javascript:verifica_iguais()">
                            </div> 
                            <label id="iguais"></label>
                        </div>
                        <label id="iguais"></label>
                        <input type="submit" class="btn btn-primary" value="Alterar" />
                        <input type="button" class="btn btn-secondary" align="center" onclick="javascript: window.history.go(-1)>Volta;" value="Cancelar" />
                    </form>
                </div>
                <div class="col-24 col-md-1"></div>
            </div>
        </div>
        <?php
            include '../roda_pe.html';
        ?>
    </div>
</body>
</html>